/**
 * Created by rockyl on 2020/9/18.
 */

import React from 'react'
import {addCanvasWidget} from 'fyge'

export class CanvasWidget extends React.Component<any, any> {
	container;

	componentDidMount() {
		const {onReady, widgetFactory, widgetConfig, onAssetsProcess, onAssetsComplete} = this.props;

		let wrapper = addCanvasWidget(widgetFactory, {
			platform: 'h5',
			container: this.container,
			onAssetsProcess,
			onAssetsComplete,
		}, widgetConfig);
		wrapper.widget.addEventListener('out', this._onEvent, this);

		onReady && onReady(wrapper.widget);
	}

	_onEvent(e) {
		const {onEvent} = this.props;
		if(e.data && onEvent){
			onEvent(e.data.type, e.data.payload);
		}
	}

	render() {
		return (
			<div ref={ref => this.container = ref} style={{width: 300, height: 300, border: "1px solid gray"}}/>
		)
	}
}
