/**
 *Created by cuiliqiang on 2018/3/13
 * 模块数据
 */
import { ResPriority } from "../enum/ResPriority";
import { ModuleType } from "../enum/ModuleType";

export interface IModuleData {
    /**
     * 模块名字
     */
    moduleName: string;

    /**
     * 模块类
     */
    moduleClass: any;

    /**
     * 视图类
     */
    viewClass: any;

    /**
     * 资源
     */
    res: string;

    /**
     * 资源加载优先级
     */
    resPriority: ResPriority;

    /**
     * 类型 1 场景， 2面板
     */
    type: ModuleType;

    /**
     * 显示层级
     */
    layerIndex: number;

    /**
     * 显示遮罩背景
     */
    showBg: boolean;

    /**
     * 是否可以事件穿透
     */
    eventPenetrate: boolean;

    /**
     * 进场动画
     */
    showAnimation?: Function;

    /**
     * 退场动画
     */
    hideAnimation?: Function;

    /**
     * UI配置
     */
    uiCfg?: any;
}