import { HtmlTextParser } from '../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
export default class RankPanel extends Panel {
    public closeBtn: eui.Button;
    public rankGroup:eui.Group;

    public tabBtn0:eui.Button;
    public tabBtn1:eui.Button;
    public getPrizeBtn:eui.Button;
    public tabLb0:eui.Label;
    public tabLb1:eui.Label;
    public noDataLb0:eui.Label;
    public noDataLb1:eui.Label;
    public myNameLb:eui.Label;
    public myRankLb:eui.Label;
    public myPrizeImg:eui.Image;
    public myScoreLb:eui.Label;

    public prizeGroup2:eui.Group;
    public prizeGroup1:eui.Group;
    public prizeGroup0:eui.Group;

    public rankScroller0:eui.Scroller;
    public rankScroller1:eui.Scroller;
    public rankGroup0:eui.Group;
    public rankGroup1:eui.Group;
    public myInfoGroup:eui.Group;
    public prizeListGroup:eui.Group;

    private hasDatas = [];

    public get skinKey() { return 'RankPanel' }
    public get groupName() { return 'rank_panel' }

    constructor(data: any) {
        super(data);

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.tabBtn0.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_tabBtn0, this);
        this.tabBtn1.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_tabBtn1, this);
        this.getPrizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_getPrizeBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.tabBtn0.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_tabBtn0, this);
        this.tabBtn1.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_tabBtn1, this);
        this.getPrizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_getPrizeBtn, this);
    }

    private initUI():void{
        this.tabBtn0.currentState = 'down';
        this.tabBtn1.currentState = 'up';

        this.tabLb0.textColor = 0xfdeaa2;
        this.tabLb0.touchEnabled = false;
        this.tabLb1.touchEnabled = false;
        this.noDataLb1.visible = false;

        this.setState(0);

        let rtData = DataManager.ins.getData(NetName.PRIZE_LIST);
        let data = [
            {name:'第1-5名', url:'https://duiba.oss-cn-hangzhou.aliyuncs.com/db_games/activity/shareImg/20200305/prizeImg01.png'},
            {name:'第6-10名', url:'https://duiba.oss-cn-hangzhou.aliyuncs.com/db_games/activity/shareImg/20200305/prizeImg11.png'},
            {name:'第11-20名', url:'https://duiba.oss-cn-hangzhou.aliyuncs.com/db_games/activity/shareImg/20200305/prizeImg21.png'}
        ]
        let space = 20;
        let space1 = 92
        for(let i = 0; i < data.length; i++){
            let img = new eui.Image();
            img.source = data[i].url;
            img.width = 108;
            img.height = 108;

            img.x = space + i * (115 + space1);
            this.prizeListGroup.addChild(img);

            let lb = new eui.Label();
            lb.text = data[i].name;
            lb.x = space + 25 + i * (112 + space1);
            lb.y = 115;
            lb.size = 17;
            this.prizeListGroup.addChild(lb);
        }
        // let data;
        // if(rtData && rtData.data){
        //     data = rtData.data;
        //     for(let i = 0; i < data.length; i++){
        //         let img = new eui.Image();
        //         img.source = data[i];
        //         img.width = 108;
        //         img.height = 108;

        //         img.x = i * 115;
        //         this.prizeListGroup.addChild(img);

        //         let lb = new eui.Label();
        //         // lb.text = '第' + this.convertNum(i) + '名';
        //         lb.text = '第' + (i + 1) + '名';
        //         lb.x = 29 + i * 115;
        //         lb.y = 109;
        //         lb.size = 17;
        //         this.prizeListGroup.addChild(lb);
                

        //     }
        // }


        let gtData = DataManager.ins.getData(NetName.GET_RANKING);
        let gdata;
        if(gtData && gtData.data){
            gdata = gtData.data;
            for(let i = 0; i < gdata.length; i++){
                let rankLb = new eui.Label();
                rankLb.text = gdata[i].index;
                rankLb.x = 22;
                rankLb.y = 19 + i * 57;
                rankLb.size = 20;
                rankLb.width = 64;
                rankLb.textAlign = egret.HorizontalAlign.CENTER;

                let nickNameLb = new eui.Label();
                nickNameLb.text = this.convertNickName(gdata[i].nickname);
                nickNameLb.x = 135;
                nickNameLb.y = 19 + i * 57;
                nickNameLb.size = 20;
                nickNameLb.width = 204;
                nickNameLb.textAlign = egret.HorizontalAlign.CENTER;

                let scoreLb = new eui.Label();
                scoreLb.text = gdata[i].score;
                scoreLb.x = 368;
                scoreLb.y = 19 + i * 57;
                scoreLb.size = 20;
                scoreLb.width = 204;
                scoreLb.textAlign = egret.HorizontalAlign.CENTER;

                let rect = new eui.Rect(570, 57);
                rect.y = i * 57;
                if(i % 2 == 0){
                    rect.fillColor = 0xf27051;
                }else{
                    rect.fillColor = 0xd24624;
                }

                this.rankGroup0.addChild(rect);
                this.rankGroup0.addChild(scoreLb);
                this.rankGroup0.addChild(nickNameLb);
                this.rankGroup0.addChild(rankLb);
            }
            if(gdata.length == 0){
                this.hasDatas[0] = 0;
                this.myInfoGroup.visible = false;
                this.prizeGroup1.visible = false;
                this.prizeGroup0.visible = false;
                this.noDataLb0.visible = true;
            }else{
                this.hasDatas[0] = 1;
                this.noDataLb0.visible = false;
            }
        }

    }

    private convertNickName(str:string):string{
        if(!str){
            return "";
        }
        let a = str.split("");
        a.splice(0,1);
        let b = a.toString();

        return '*' + b.replace(/,/g,'');
    }

    private convertNum(num:number):string{
        let str = ''
        switch(num){
            case 0:
                str = '一';
                break;
            case 1:
                str = '二';
                break;
            case 2:
                str = '三';
                break;
            case 3:
                str = '四';
                break;
            case 4:
                str = '五';
                break;
            case 5:
                str = '六';
                break;
            case 6:
                str = '七';
                break;
            case 7:
                str = '八';
                break;
            case 8:
                str = '九';
                break;
            case 9:
                str = '十';
                break;
        }

        return str;
    }

    private setState(type:number):void{
        console.log('type', type);
        switch(type){
            case 0://上期
                this.prizeGroup2.visible = true;
                this.prizeGroup1.visible = false;
                this.prizeGroup0.visible = false;

                this.rankScroller0.height = 511;
                this.myInfoGroup.y = 861;

                this.rankScroller0.visible = true;
                this.rankScroller1.visible = false;

                let mdata = DataManager.ins.getData(NetName.RANKING_TYPE_INFO).data;
                if(mdata.curRankingInfo.index > 100 || !mdata.curRankingInfo.index){
                    this.myRankLb.text = '未上榜';
                }else{
                    this.myRankLb.text = mdata.curRankingInfo.index;
                }
                this.myScoreLb.text = mdata.curRankingInfo.score;
                this.myInfoGroup.visible = true;
                break;
            case 1://中奖了
                this.prizeGroup2.visible = false;
                this.prizeGroup1.visible = false;
                this.prizeGroup0.visible = true;

                this.rankScroller0.visible = false;
                this.rankScroller1.visible = true;

                this.rankScroller1.height = 345;
                this.myInfoGroup.y = 695;

                let mdata1 = DataManager.ins.getData(NetName.RANKING_TYPE_INFO).data;
                if(mdata1.lastRankingInfo){

                    if(mdata1.lastRankingInfo.index > 100 || !mdata1.lastRankingInfo.index){
                        this.myRankLb.text = '未上榜';
                    }else{
                        this.myRankLb.text = mdata1.lastRankingInfo.index;
                    }
                    this.myScoreLb.text = mdata1.lastRankingInfo.score;
                    this.myInfoGroup.visible = true;
                }else{
                    this.myInfoGroup.visible = false;
                    this.prizeGroup1.visible = false;
                    this.prizeGroup0.visible = false;
                }
                break;
            case 2://未中奖
                this.prizeGroup2.visible = false;
                this.prizeGroup1.visible = true;
                this.prizeGroup0.visible = false;

                this.rankScroller0.visible = false;
                this.rankScroller1.visible = true;

                this.rankScroller1.height = 580;
                this.myInfoGroup.y = 930;

                mdata1 = DataManager.ins.getData(NetName.RANKING_TYPE_INFO).data;
                if(mdata1.lastRankingInfo){

                    if(mdata1.lastRankingInfo.index > 100 || !mdata1.lastRankingInfo.index){
                        this.myRankLb.text = '未上榜';
                    }else{
                        this.myRankLb.text = mdata1.lastRankingInfo.index;
                    }
                    this.myScoreLb.text = mdata1.lastRankingInfo.score ? mdata1.lastRankingInfo.score : 0;
                    this.myInfoGroup.visible = true;
                }else{
                    this.myInfoGroup.visible = false;
                    this.prizeGroup1.visible = false;
                    this.prizeGroup0.visible = false;
                }
                break;
        }
    }

    private onBegin_tabBtn0():void{
        this.tabBtn0.currentState = 'down';
        this.tabBtn1.currentState = 'up';

        this.tabLb0.textColor = 0xfdeaa2;
        this.tabLb1.textColor = 0xffffff;

        this.setState(0);

        if(this.hasDatas[0] == 0){
            this.noDataLb0.visible = true;
        }else{
            this.noDataLb0.visible = false;
        }
        this.noDataLb1.visible = false;
    }

    private isfrist;
    private onBegin_tabBtn1():void{
        this.tabBtn0.currentState = 'up';
        this.tabBtn1.currentState = 'down';

        this.tabLb0.textColor = 0xffffff;
        this.tabLb1.textColor = 0xfdeaa2;

        if(this.hasDatas[1] == 0){
            this.noDataLb1.visible = true;
        }else{
            this.noDataLb1.visible = false;
        }
        this.noDataLb0.visible = false;

        if(!this.isfrist){
            this.isfrist = true;
            let rtData = DataManager.ins.getData(NetName.RANKING_TYPE_INFO);
            let type;
            if(rtData && rtData.data){
                type = rtData.data.lastType;
            }
            
            NetManager.ins.getRanking((success1)=>{
                if(success1){

                    NetManager.ins.winInfo((success2)=>{
                        if(success2){
                            let data = DataManager.ins.getData(NetName.WIN_INFO).data;
                            if(data.win){//中奖
                                this.setState(1);
                                this.prizeUrl = data.url;
                                this.myPrizeImg.source = data.img;
                                if(data.recieved){
                                    this.prizeUrl = null;
                                }
                            }else{
                                this.setState(2);
                            }
                        }else{//获取是否中奖失败
                            
                            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'网络异常，请稍后再试~'});
                        }
                    })
                    let gtData = DataManager.ins.getData(NetName.GET_RANKING);
                    let gdata;
                    if(gtData && gtData.data){
                        gdata = gtData.data;
                        for(let i = 0; i < gdata.length; i++){
                            let rankLb = new eui.Label();
                            rankLb.text = gdata[i].index;
                            rankLb.x = 22;
                            rankLb.y = 19 + i * 57;
                            rankLb.size = 20;
                            rankLb.width = 64;
                            rankLb.textAlign = egret.HorizontalAlign.CENTER;

                            let nickNameLb = new eui.Label();
                            nickNameLb.text = this.convertNickName(gdata[i].nickname);
                            nickNameLb.x = 135;
                            nickNameLb.y = 19 + i * 57;
                            nickNameLb.size = 20;
                            nickNameLb.width = 204;
                            nickNameLb.textAlign = egret.HorizontalAlign.CENTER;

                            let scoreLb = new eui.Label();
                            scoreLb.text = gdata[i].score;
                            scoreLb.x = 368;
                            scoreLb.y = 19 + i * 57;
                            scoreLb.size = 20;
                            scoreLb.width = 204;
                            scoreLb.textAlign = egret.HorizontalAlign.CENTER;

                            let rect = new eui.Rect(570, 57);
                            rect.y = i * 57;
                            if(i % 2 == 0){
                                rect.fillColor = 0xf27051;
                            }else{
                                rect.fillColor = 0xd24624;
                            }
            
                            this.rankGroup1.addChild(rect);
                            this.rankGroup1.addChild(scoreLb);
                            this.rankGroup1.addChild(nickNameLb);
                            this.rankGroup1.addChild(rankLb);
                        }
                        if(gdata.length == 0){
                            this.hasDatas[1] = 0;
                            this.myInfoGroup.visible = false;
                            this.prizeGroup1.visible = false;
                            this.prizeGroup0.visible = false;
                            this.noDataLb1.visible = true;
                        }else{
                            this.noDataLb1.visible = false;
                            this.hasDatas[1] = 1;
                        }
                    }
                }else{//获取排行榜信息失败
                    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'网络异常，请稍后再试~'});
                }
            }, type, 100, '1');
        }else{
            let data = DataManager.ins.getData(NetName.WIN_INFO);
            if(data.win){//中奖
                this.setState(1);
            }else{
                this.setState(2);
            }
        }
    }

    private prizeUrl:string;
    private onTap_getPrizeBtn():void{
        PanelCtrl.instance.btnDelay(this.getPrizeBtn);

        if(this.prizeUrl){
            NetManager.ins.recievePrize((success)=>{
                if(success){
                    console.log('写出领取记录成功');
                    window.location.href = this.prizeUrl;
                    //刷新中奖状态
                    NetManager.ins.winInfo((success2)=>{
                        // let data = DataManager.ins.getData(NetName.WIN_INFO).data;
                        // if(data.win){//中奖
                        //     this.setState(1);
                        //     this.prizeUrl = data.url;
                        //     if(data.recieved){
                        //         this.prizeUrl = null;
                        //     }
                        // }else{
                        //     this.setState(2);
                        // }
                    });
                }else{
                    console.log('写出领取记录失败')
                }
            })
        }else{
            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'奖品已经领取过了！'});
        }
    }

    private onLoad(): void {

        this.initUI();
        let uInfoData = DataManager.ins.getData(NetName.GET_PROJECT_USER_INFO);
        if(uInfoData && uInfoData.data){
            uInfoData = uInfoData.data;
            this.myNameLb.text = this.convertNickName(uInfoData.nickName);
        }else{
            this.myNameLb.text = '未取到';
        }

        let mdata = DataManager.ins.getData(NetName.RANKING_TYPE_INFO).data;
        if(mdata.curRankingInfo.index > 100 || !mdata.curRankingInfo.index){
            this.myRankLb.text = '未上榜';
        }else{
            this.myRankLb.text = mdata.curRankingInfo.index;
        }
        this.myScoreLb.text = mdata.curRankingInfo.score;

        //排行信息
        let data = DataManager.ins.getData(NetName.GET_RANKING).data;
        if(!data) return;

        let idxStr;
        for(let i = 0; i < data.length; i++){
            let idata = data[i];
            if(i == 0){
                idxStr = idata.nickname;
            }else{
                idxStr += ',' + idata.nickname;
            }
        }

        
    }


}