import { LotteryType } from '../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
export default class PrizePanel2 extends Panel {
    private mdata: any;
    private pType: any;

    public closeBtn: eui.Button;
    public codeLb: eui.Label;
    public useBtn: eui.Group;
    public copyBtn:eui.Button;
    public moneyLb:eui.Label;

    public codeGroup:eui.Group;

    public get skinKey() { return 'PrizePanel2' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.pType = data;

    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct(function () {

        }.bind(this));
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.useBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        this.copyBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_copyBtn, this);

    }

    removeEvents(): void {
        super.removeEvents();
        this.useBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        this.copyBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_copyBtn, this);

    }

    private onTap_copyBtn():void{
        PanelCtrl.instance.btnDelay(this.copyBtn);

        this.copyUrl(this.mdata.coupon_code);
    }

    private onLoad() {

        // let startDpmOut = Buried.connectDpm(110, 10, 1); // 点击埋点   
        // let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        // let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        // NetManager.ins.showLog(exposure);

        // if(this.pType == 0){
            
        // }else{

        // }
        let data = DataManager.ins.getData(NetName.GET_PRIZE_DETAIL).data;
        if(data.length > 0){
            data = data[0];
            this.moneyLb.text = data.name;
        }


        this.mdata = DataManager.ins.getData(NetName.GET_COUPON_INFO).data;
        this.codeLb.text = '领取串码：' + this.mdata.coupon_code;
    }

    onUse() {
        let data = DataManager.ins.getData(NetName.GET_COUPON_INFO).data;
        window.location.href = data.link;
    }


    private onTap_ok(e: egret.TouchEvent): void {

        // let startDpmOut = Buried.connectDpm(110, 10, 1); // 点击埋点   
        // let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        // let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        // NetManager.ins.clickLog(exposure);
        
        // this.onUse();
        this.onTouchTap();
        this.share();
    }

    private copyUrl(str:string):void {
        var oInput = document.createElement('input');
        oInput.value = str;
        document.body.appendChild(oInput);
        oInput.select();
        document.execCommand("Copy");
        oInput.style.display = 'none';
        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'已复制'});
    }

    private share():void{
        //进入分享流程
        var param = {
			"shareTitle" : window['shareTitle'] ? window['shareTitle'] : '听吴侬软语，寻姑苏美食',// 标题
			"shareTextUrl" : window['shareTextUrl'] ? window['shareTextUrl'] : 'https://activity-1.m.duiba.com.cn/hdtool/index?id=3721052&appKey=U9smCw8qARxWTzoSvL41McNWiRu&openBs=openbs',// 链接
			"shareText" : window['shareText'] ? window['shareText'] : '开启美味追忆之旅，还有大闸蟹、现金红包等小食礼品你来拿哦！',// 分享文本内容
			"sequence":'110',//分享三个按钮的显示与隐藏
			"showDialog":'true', //是否需要底部弹出层
			"shareAlertTitle":'分享', //分享弹出层标题
			"callback":"shareCallBack" //分享回调方法
        };
        
        window['shareCallBack'] = (data)=>{
            let data1 = DataManager.ins.getData(NetName.GET_INFO).data;
            let endtime = new Date(window['endtime'] ? window['endtime'] : '2019-11-16 00:00:00').getTime();
            console.log('分享返回参数data:', data);
            if(data1.timestamp > endtime){
                //提示活动已结束
                PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, 3);
            }else{

                let issuccess:boolean;

                var u = navigator.userAgent;//, app = navigator.appVersion;
                var android = u.indexOf('Android') > -1 || u.indexOf('Linux') > -1; //g
                var iphone = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端

                if(android){
                    if(data == '0'){
                        issuccess = true;
                    }else{
                        issuccess = false;
                    }
                }

                if(iphone){

                    if(data == '1'){
                        issuccess = true;
                    }else{
                        issuccess = false;
                    }
                }

                if(issuccess){
                    //alert("分享成功");
                    console.log("分享成功");
                    NetManager.ins.shareData((success)=>{
                        if(success){//加次数成功
                            PanelCtrl.instance.show(ModuleTypes.SHARE_SUC_PANEL);
                        }else{
                            //加次数失败
                            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'活动太火爆了，请稍后重试~'});
                        }
                    });
                }else{
                    //alert("分享失败");
                    console.log("分享失败");
    
                    PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, 0);
    
                    // TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'分享失败！'});
                }
            }
            
        }
        window['ThirdApp'].webviewShare(param);
    }

}