import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from '../ctrls/panelCtrl';
import { NetName } from '../../libs/tw/enum/NetName';
import { ModuleTypes } from '../types/sceneTypes';
import Loading from '../loading/Loading';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import { Buried } from '../../libs/tw/util/Buried';
export default class LotBoxPanel extends Panel {
    public img: eui.Image;
    public closeBtn: eui.Button;
    public redMapleTxt: eui.Label;
    public titleLb:eui.Label;
    public useBtn: eui.Group;
    private lData:any;

    public get skinKey() { return 'LotBoxPanel' }
    // public get groupName() { return 'rule_panel' }

    constructor(data: any) {
        super(data);

        this.lData = data;

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.useBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_useBtn, this)
    }

    removeEvents(): void {
        super.removeEvents();
        this.useBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_useBtn, this)
    }
    onTap_useBtn(){
        PanelCtrl.instance.btnDelay(this.useBtn);


        let startDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        this.hidePanel();
        if(!this.data) return;

        Loading.instace.show();
        //消耗红枫，打开盲盒
        NetManager.ins.exchangeProject((success)=>{
            if(!success){
                Loading.instace.hide();
                let result = DataManager.ins.getData(NetName.EXCHANGE_PROJECT);
                if(result.code == '530003'){

                    PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL);
                }else{

                    PanelCtrl.instance.show(ModuleTypes.EXMSG_PANEL);
                }
                return;
            }

            GDispatcher.dispatchEvent('refreshMangheBtn');
            let data = DataManager.ins.getData(NetName.EXCHANGE_PROJECT).data;
            if(data.prizeId == 'thanks'){
                PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL);
            }else{
                PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL);
            }
            Loading.instace.hide();
        },this.data.prizeId);
    }

    private onLoad(): void {

        let startDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);

        if(this.lData){
            //盲盒图片
            this.img.source = this.lData.icon;
            this.titleLb.text = '您将消耗' + this.lData.needAmount + '片红枫抽\n一个盲盒'
            //根据数据
            this.redMapleTxt.text = "我的红枫：" + DataManager.ins.getGameInfoData.totalAmount;
        }else{
            //盲盒图片
            this.img.source = ""
            this.titleLb.text = '';
            //根据数据
            this.redMapleTxt.text = "我的红枫：" + 0;
        }
    }


}