import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
import { NetName } from '../../libs/tw/enum/NetName';
import SceneCtrl from '../ctrls/sceneCtrl';
export default class GameOverPanel extends Panel {
    public closeBtn: eui.Button;
    public againBtn: eui.Button;
    public jietuBtn: eui.Button;
    public shareBtn:eui.Button;
    public shareBtn2:eui.Button;

    public scoreLb:eui.Label;
    public bestLb:eui.Label;
    public rankLb:eui.Label;
    public hitLb:eui.Label;

    private prizeAct0:SVGA.EgretMovieClip;
    private newRecord:SVGA.EgretMovieClip;

    public icon0:eui.Image;
    public icon1:eui.Image;
    private gData;

    public get skinKey() { return 'GameOverPanel' }
    public get groupName() { return 'gameover_panel' }

    constructor(data: any) {
        super(data);
        this.gData = data;
    }

    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('startBg_jpg');
        await RES.loadGroup('common');
        this.prizeAct0 = await PanelCtrl.instance.getSvga('resource/assets/svga/prize/prizeAct0.svga') as SVGA.EgretMovieClip;
        this.newRecord = await PanelCtrl.instance.getSvga('resource/assets/svga/prize/newRecord.svga') as SVGA.EgretMovieClip;
        this.prizeAct0.touchEnabled = false;
        this.newRecord.touchEnabled = false;

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.againBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this)
        this.shareBtn2.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn2, this)
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this)
    }

    removeEvents(): void {
        super.removeEvents();
        this.againBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this)
        this.shareBtn2.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn2, this)
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this)
    }
    onTap_againBtn() {
        this.onTouchTap();
    }

    private onTap_shareBtn():void{
        PanelCtrl.instance.btnDelay(this.shareBtn);
        this.onTouchTap();
        this.doShare();
    }

    private onTap_shareBtn2():void{
        PanelCtrl.instance.btnDelay(this.shareBtn2);
        this.onTouchTap();
        this.doShare();
    }

    private doShare():void{
        let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.clickLog(exposure);
        
        if(window['SNNativeClient']){
            window['SNNativeClient'].callNativeShareUrl({
                shareTypeList:["WXChat","WXFriends"],
                shareTitle:window['shareTitle'] ? window['shareTitle'] : "数钱赢壕礼！越数约happy~",
                shareContent:window['shareCont'] ? window['shareCont'] : "上苏宁金融和我一起猫咪数钱，缤纷好礼免费送！",
                shareUrl:window['shareUrl'] ? window['shareUrl'] : 'http://activity.m.duiba.com.cn/customShare/share?id=3802',
                imageUrl:'https://duiba.oss-cn-hangzhou.aliyuncs.com/db_games/activity/shareImg/20200228/shareImg.png',
                // cbFunc:null
            })

            setTimeout(() => {
                this.onCallBack();
            }, 2000);
        }
    }


    private onCallBack():void{

        NetManager.ins.share((success)=>{
            if(success){
                console.log('分享加次数成功！');
                NetManager.ins.baseInfo(()=>{
                    let data = DataManager.ins.getData(NetName.BASE_INFO);
                    if(data && data.data){
                        //刷新次数成功
                    }else{
                        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'次数刷新失败，请刷新界面~'});
                    }
                })
            }else{
                let sdata = DataManager.ins.getData(NetName.SHARE);
                if(sdata.code == '100033'){

                }else{
                    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'分享加次数失败！'});
                }
            }
        })
    }
    
    onTouchTap():void{
        super.onTouchTap();

        NetManager.ins.baseInfo((success1)=>{
            if(success1){
                NetManager.ins.getProjectUserInfo((success2)=>{
                    if(success2){
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                    }else{

                        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'网络异常，请稍后再试~'});
                    }
                })
            }else{

                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'网络异常，请稍后再试~'});
            }

        });

    }

    private onLoad(): void {

        let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.showLog(exposure);

        let data = DataManager.ins.getData(NetName.SUBMIT);
        let subdata;
        if(data && data.data){
            subdata = data.data;
            if(subdata.newRecord){//有新记录
                this.bestLb.visible = false;

                this.panelGroup.addChild(this.prizeAct0);
                this.panelGroup.addChild(this.newRecord);

                this.newRecord.startAniRange(0, this.newRecord.totalFrames, 1);
                this.newRecord.x = 90;
                this.newRecord.y = 235;
                this.prizeAct0.x = -90;

            }else{//没有新纪录
                this.bestLb.text = '最佳成绩：' + subdata.maxScore;
                this.bestLb.visible = true;
            }

            this.scoreLb.text = '¥' + subdata.finalScore;
            this.rankLb.text = '我的排名：' + (subdata.ranking ? subdata.ranking : '未上榜');
            this.hitLb.textFlow = [
                {text: '打败了'},
                { text: subdata.defeat + '%', style:{textColor:0xba2107} },
                { text: '的对手'}
            ];


            switch(this.gData.type){
                case 0:
                    this.shareBtn.visible = true;
                    this.shareBtn2.visible = false;
                    this.againBtn.visible = false;
                    
                    this.icon0.visible = true;
                    this.icon1.visible = false;
                    break;
                case 1:

                    this.shareBtn.visible = false;
                    this.shareBtn2.visible = true;
                    this.againBtn.visible = true;
                    
                    this.icon0.visible = false;
                    this.icon1.visible = true;
                    break;
            }
            
        }

    }


}