import { HtmlTextParser } from '../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
export default class BagPanel extends Panel {
    public closeBtn: eui.Button;
    public bag0:eui.Image;
    public bag1:eui.Image;

    public get skinKey() { return 'BagPanel' }
    public get groupName() { return 'bag_panel' }

    constructor(data: any) {
        super(data);

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this)
    }
    onTap_knowBtn(e:egret.TouchEvent) {

        //关闭弹框

        PanelCtrl.instance.btnDelay(this);
        this.hidePanel();
        if(e.target == this['closeBtn']){
            console.log('true');
            return;
        }


        if(window['isapp']){
            let startDpmOut = Buried.connectDpm(110, 12, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.clickLog(exposure);
        }

        NetManager.ins.getPrize((success)=>{
            if(success){
                let data = DataManager.ins.getData(NetName.GET_PRIZE).data;

                if(data.prizeId == 'thanks'){
                    //谢谢参与
                    PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, 1);
                }else{
                    NetManager.ins.getPrizeDetail((success)=>{
                        if(success){
                            let data = DataManager.ins.getData(NetName.GET_PRIZE_DETAIL).data;
                            if(data.length > 0){
                                data = data[0];
                            }
                            
                            if(data.refType == 'coupon'){
                                let data1 = DataManager.ins.getData(NetName.GET_PRIZE).data;

                                this.times = 5;
                                this.loopNet(data1.userRecordId);
                                
                            }else{
                                PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL);
                            }
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, 2);
                            
                        }
                    }, data.prizeId)
                }
            }else{
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'活动太火爆了，请稍后重试~'});
            }
        })
    }

    private times:number;
    private loopNet(userRecordId:string):void{
        if(this.times < 1){
            //轮询失败
            
            PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, 2);
            return;
        }
        //获取券码券详情
        NetManager.ins.getCouponInfo((success)=>{
            this.times --;
            if(success){
                let data = DataManager.ins.getData(NetName.GET_COUPON_INFO).data;
                if(!data){
                    setTimeout(() => {
                        this.loopNet(userRecordId);
                    }, 500);
                }else{
                    PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL2);
                }
            }else{
                setTimeout(() => {
                    this.loopNet(userRecordId);
                }, 500);
            }
        }, userRecordId);
    }

    private onLoad(): void {
        if(window['isapp']){
            let startDpmOut = Buried.connectDpm(110, 12, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.showLog(exposure);
        }

        this.bag0.alpha = 0;
        this.bag1.alpha = 1;
        setInterval(()=>{
            if(this.bag0.alpha == 0){
                this.bag0.alpha = 1;
            }else{
                this.bag0.alpha = 0;
            }
        }, 1000);

        setInterval(()=>{
            if(this.bag1.alpha == 0){
                this.bag1.alpha = 1;
            }else{
                this.bag1.alpha = 0;
            }
        }, 1000);
        // let startDpmOut = Buried.connectDpm(110, 9, 1); // 点击埋点   
        // let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        // let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        // NetManager.ins.showLog(exposure);
    }


}