import { DataManager } from '../../libs/tw/manager/DataManager';
import { ModuleTypes } from '../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { VideoEntity } from '../../libs/SVGA';
import SceneCtrl from '../ctrls/sceneCtrl';
import StartScene1 from '../startScene/StartScene';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import ProgressBarS from './ProgressBarS';
import { NetName } from '../../libs/tw/enum/NetName';
export default class LoadingScene extends Scene {
    perTxt: eui.Label;
    loadingMark: eui.Image;
    public barImg:eui.Image;
    public barGroup:eui.Group;
    private maskShap:egret.Shape;

    private currVal:number;
    private endVal:number;


    progressBar: ProgressBarS

    public get skinKey() { return 'LoadingScene' }
    public get groupName() { return 'loadingscene' }

    constructor(data?) {
        super(data);

    }

    initEvents() {
        super.initEvents();

        GDispatcher.addEvent("PROGRESS", this.onProgress, this);
    }

    removeEvents() {
        super.removeEvents();

    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }
    
    private setMask():void{

        this.maskShap = new egret.Shape();
        this.maskShap.x = 9;
        this.maskShap.y = 6.5;
        this.barGroup.addChild(this.maskShap);

        this.maskShap.graphics.beginFill(0xe6844e, 1);
        this.maskShap.graphics.drawRoundRect(0, 0, 443, 55,70)  //宽度0到443
        this.maskShap.graphics.endFill();
        this.barImg.mask = this.maskShap;
    }

    private onLoad(): void {
        Loading.instace.hide();

        this.setMask();
        this.maskShap.x = -435;
    }
    private itervalIdx:number = 0;
    private perVal:number = 0;
    onProgress(per) {
        egret.Tween.removeTweens(this.maskShap);
        let spaceTime = ((per * 4.43) - (this.maskShap.x + 435)) * (2500 / 443);
        egret.Tween.get(this.maskShap).to({x:per * 4.43 - 435 }, spaceTime).call(()=>{
            if(per >= 100){
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                NetManager.ins.getCoopTimes((success)=>{
                    if(success){
                        // let data = DataManager.ins.getData(NetName.GET_COOP_TIEMS);
                        // if(data && data.data){
                        //     window['rankNum'] = data.data.completeNum;
                        //     window['invokeWX'] = this.invokeWX;
                        //     window['invokeWX']();
                        // }
                    }else{
                        console.log('名词没拿到')
                    }
                })
            }
        });

        if(this.itervalIdx){
            clearInterval(this.itervalIdx);
        }

        this.itervalIdx = setInterval(()=>{
            if(this.perVal < per){
                this.perVal ++;
            }else{
                clearInterval(this.itervalIdx);
            }
            this.perTxt.text = this.perVal + '%';

            if(this.perVal >= 100){
                clearInterval(this.itervalIdx);
            }
        }, 25);

    }

    private invokeWX() {
        if(!window['rankNum']) window['rankNum'] = '';
        window['wx'].onMenuShareTimeline({
            title:"澳门印象，一起“拼”！我是第" + window['rankNum'] +  "个为澳门送祝福的人！",
            link: 'https://activity.m.duiba.com.cn/aaw/projectx/openBs?redirectUrl=http://activity-1.m.duiba.com.cn/projectx/p593e837c/index.html&appKey=41ERxnBm9uhC6MMS2fD2noYkdrtu&openBs=openbs',
            imgUrl: 'https://yun.duiba.com.cn/db_games/activity/shareImg/20191210/shareImg.jpg',
            success: function() {
          
            },
            cancel: function() {}
        });
        window['wx'].onMenuShareAppMessage({
            title:"澳门印象，一起“拼”！我是第" + window['rankNum'] +  "个为澳门送祝福的人！",
            desc:"快乐拼图，祝福澳门",
            link:'https://activity.m.duiba.com.cn/aaw/projectx/openBs?redirectUrl=http://activity-1.m.duiba.com.cn/projectx/p593e837c/index.html&appKey=41ERxnBm9uhC6MMS2fD2noYkdrtu&openBs=openbs',
            imgUrl: 'https://yun.duiba.com.cn/db_games/activity/shareImg/20191210/shareImg.jpg',
            success: function(res) {
                    
            },
            cancel: function(res) {},
            fail: function(res) {}
        });
    }


}
