import { GDispatcher } from "../../libs/tc/util/GDispatcher";

export default class NumGroup extends eui.Group {
    private numLb0:eui.Label;
    private numLb1:eui.Label;
    private numLb2:eui.Label;
    private pNums:number[];

    private currNum:number;
    private psotName:string;
    private receiveName:string;
    constructor(postName?:string, receiveName?:string,) {
        super();
        this.currNum = 0;
        this.pNums = [];
        this.psotName = postName;
        this.receiveName = receiveName;
        this.initUI();
    }


    private receive():void{
        this.pushNum();
    }

    private initUI():void{
        GDispatcher.addEvent(this.receiveName, this.receive, this);
        this.numLb0 = new eui.Label();
        this.numLb1 = new eui.Label();

        this.addChild(this.numLb0);
        this.addChild(this.numLb1);

        this.numLb0.size = 50;
        this.numLb1.size = 50;

        this.numLb0.textColor = 0xB73D13;
        this.numLb1.textColor = 0xB73D13;
    
        this.numLb0.width = 28;
        this.numLb1.height = 28;

        this.numLb0.textAlign = egret.VerticalAlign.JUSTIFY;
        this.numLb1.textAlign = egret.VerticalAlign.JUSTIFY;

        this.numLb0.y = 79 + 16;
        this.numLb1.y = 16;
        this.numLb0.x = 16;
        this.numLb1.x = 16;

        this.height = 158;
        this.y = -79;
        this.numLb1.text = '1';
        this.numLb0.text = '0';

        this.currNum = 0;

        // egret.Tween.get(this).to({y:0}, 200).call(()=>{
        //     this.y = -79;
        // });
        this.interverIdx = setInterval(()=>{
            if(this.pNums.length > 0){
                this.pNums.pop();

                this.currNum ++;
                if(this.currNum > 9){
                    GDispatcher.dispatchEvent(this.psotName);
                    this.currNum = 0;
                }
                egret.Tween.get(this).to({y:0}, 50).call(()=>{

                    this.numLb1.text = (this.currNum + 1 > 9 ? 0 : this.currNum + 1) + '';
                    this.numLb0.text = this.currNum + '';
                    this.y = -79;
                })

                
            }
        }, 50);
    }

    public interverIdx;
    public pushNum():void{
        this.pNums.push(1);
    }
}