export as namespace SVGA;

declare global {
    const SVGA: {
        Parser: typeof Parser,
        EgretMovieClip: typeof EgretMovieClip,
    }
}

export class VideoEntity {
    videoSize: { width: number, height: number }
    FPS: number
    frames: number
}

export class Parser {
    load(url: string, success: (videoItem: VideoEntity) => void, failure?: (err: Error) => void): void
}

export class EgretMovieClip extends egret.DisplayObjectContainer {
    /**
     * 锁步，只关心每帧间隔时间，不管浏览器帧率
     * 默认false
     */
    lockStep: boolean;
    /**
     * 当前帧数
     * 1最小
     */
    readonly currentFrame: number;
    /**
     * 是否播放
     */
    readonly isPlaying: boolean;
    /**
     * 正序还是反序
     */
    readonly isFront: boolean;
    /**
     * 所有帧数
     */
    totalFrames: number;
    /**
     * 停止
     */
    stop(): void;
    /**
     * 播放
     */
    play(): void;
    /**
     * 进入下一帧
     */
    nextFrame(): void;
    /**
     * 进入上一帧
     */
    prevFrame(): void;
    /**
     * 停在指定帧
     * @param frameIndex 
     */
    gotoAndStop(frameIndex: number): void;
    /**
     * 从某帧开始播放
     * @param frameIndex 1开始
     * @param isFront 默认true正向播放
     */
    gotoAndPlay(frameIndex: number, isFront: boolean): void;
    readonly isInTimeFrame: boolean;
    /**
     * 帧数范围播放
     * @param beginFrame 开始播放的帧序号，默认第一帧
     * @param endFrame 结束播放的帧序号，默认最后一帧
     * @param loops 循环次数， 默认0，表示无限循环，无限循环callback无效，因为永远不会完成，用正常的complete监听最后一帧或第一帧
     * @param callback 所有播放完的回调 
     */
    startAniRange(beginFrame: number, endFrame: number, loops: number, callback?: Function): void
    constructor(mv: VideoEntity)
}
