import Panel from "../views/Panel";

export default class ReadSucPanel extends Panel {
    public get skinKey() { return "ReadSuc" }
    public get groupName() { return "readSuc_Panel" }

    public closeBtn: eui.Button;
    public statusTitle: eui.Label;
    public acceptBtn: eui.Button;
    public prizeTips: eui.Label;
    public prizeImg: eui.Image;
    public prizeNum: eui.Label;
    public prizeNum1: eui.Label;
    public prizeNum0: eui.Label;

    private readRewardCnt: any;
    private callback: Function = () => { }

    constructor(data) {
        super()
        this.readRewardCnt = data.readRewardCnt;
        this.callback = data.callback;
    }


    onSkinComplete() {
        super.onSkinComplete();

        this.prizeNum0.text = `${this.readRewardCnt}`
        this.prizeNum1.text = `${this.readRewardCnt}`
    }


    initEvents() {
        super.initEvents();

        this.acceptBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_acceptBtn, this);
    }

    onTap_acceptBtn() {
        this.onTouchTap();
    }

    onTouchTap() {
        super.onTouchTap();
        this.callback();
    }


    removeEvents() {
        super.removeEvents();

        this.acceptBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_acceptBtn, this);

    }
}