import Scene from "../views/Scene";
import GameConst from "../GameConst";

export default class HelpScene extends Scene {
    public get skinKey() { return "Help" }
    public get groupName() { return "help_Scene" }

    public helpBtn: eui.Button;

    private shareCode: string;

    onSkinComplete() {
        super.onSkinComplete();

        this.shareCode = GameConst.getQueryString("shareCode");
        // console.log(shareCode)
    }

    initEvents() {
        super.initEvents();
        this.helpBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_helpBtn, this);
    }

    onTap_helpBtn() {
        window.location.href = `${window["shareUrl"]}&sharecode=${this.shareCode}`
    }

    removeEvents() {
        super.removeEvents();
        this.helpBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_helpBtn, this);
    }
}