"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var GDispatcher_1 = require("../../libs/tc/util/GDispatcher");
var Buried_1 = require("../../libs/tw/util/Buried");
var GuidePanel_1 = require("../guidePanel/GuidePanel");
/**
 * 出游界面
 */
var TourPanel = (function (_super) {
    __extends(TourPanel, _super);
    function TourPanel() {
        var _this = _super.call(this) || this;
        _this.init();
        return _this;
    }
    Object.defineProperty(TourPanel.prototype, "skinKey", {
        get: function () { return 'Tour'; },
        enumerable: true,
        configurable: true
    });
    TourPanel.prototype.init = function () {
        this.onHidePop(); //出游确认提示框默认不显示
        this.flagGroup = new eui.Group();
        this.mapUnlock.addChild(this.flagGroup);
        this.startPos = new egret.Point();
        this.mapUnlock.mask = this.maskGroup;
        this.mapUnlock.touchEnabled = this.mapUnlock.touchChildren = false;
        this.bgGroup.touchEnabled = this.bgGroup.touchChildren = false;
        this.curMapName = '中国';
        this.changeMap();
    };
    /**
     * 初始化tab按钮和背景图和地图
     */
    TourPanel.prototype.initMapAndBg = function () {
        this.mapUnlock.x = 0;
        this.mapUnlock.y = 0;
        for (var i = 0; i < 3; i++) {
            this['tabBtn_' + i].currentState = 'up';
            this['bg_' + i].visible = false;
            if (this['mapUnlockImg' + i]) {
                this['mapUnlockImg' + i].visible = false;
            }
            if (this['mapLockImg' + i]) {
                this['mapLockImg' + i].visible = false;
            }
        }
    };
    TourPanel.prototype.start = function (data) {
        this.percentHeight = 100;
        this.guideBack = data;
        if (this.guideBack) {
            this.showGuide(6);
        }
    };
    /**
     * 切换地图
     * @param e
     */
    TourPanel.prototype.changeMap = function (e) {
        var _this = this;
        if (e) {
            if (this.curMapName == e.currentTarget.label) {
                return;
            }
            this.curMapName = e.currentTarget.label;
        }
        this.initMapAndBg();
        var mapLockCFG = window['mapLockCFG'] ? window['mapLockCFG'] : {};
        var lvArr = mapLockCFG[this.curMapName];
        if (lvArr.indexOf(DataManager_1.DataManager.ins.petHomeInfoData.petLevel) != -1) {
            //当前地图场景已解锁开放
            this.isUnLock = true;
            this.controlGroup.visible = true;
            this.mapUnlock.visible = true;
            this.mapLock.visible = false;
            this.lock.visible = false;
            //获取当前地图集卡
            NetManager_1.NetManager.ins.getCollectRule(function () {
                _this.updateFlag();
            }, window['collectRuleIdList'] ? window['collectRuleIdList'][this.curMapName == '中国' ? 0 : (this.curMapName == '亚洲' ? 1 : 2)] : 1);
        }
        else {
            this.isUnLock = false;
            this.controlGroup.visible = false;
            this.mapUnlock.visible = false;
            this.mapLock.visible = true;
            this.lock.visible = true;
        }
        if (this.curMapName == '中国') {
            //点击埋点，中国
            var dpm = Buried_1.Buried.connectDpm(110, 2, 3);
            var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
            var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
            var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
            NetManager_1.NetManager.ins.clickLog(exposure);
            this.bg_0.visible = true;
            this.tabBtn_0.currentState = 'down';
            this.mapUnlockImg0.visible = true;
        }
        else if (this.curMapName == '亚洲') {
            //点击埋点，亚洲
            var dpm = Buried_1.Buried.connectDpm(110, 2, 4);
            var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
            var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
            var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
            NetManager_1.NetManager.ins.clickLog(exposure);
            this.bg_1.visible = true;
            this.tabBtn_1.currentState = 'down';
            this.mapUnlockImg1.visible = this.mapLockImg1.visible = true;
        }
        else if (this.curMapName == '欧洲') {
            //点击埋点，欧洲
            var dpm = Buried_1.Buried.connectDpm(110, 2, 5);
            var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
            var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
            var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
            NetManager_1.NetManager.ins.clickLog(exposure);
            this.bg_2.visible = true;
            this.tabBtn_2.currentState = 'down';
            this.mapLockImg2.visible = true;
        }
    };
    /**
     * 插旗
     */
    TourPanel.prototype.updateFlag = function () {
        this.flagGroup.removeChildren();
        var mapPosCFG = window['mapPosCFG'] ? window['mapPosCFG'] : {};
        var rule = DataManager_1.DataManager.ins.getCollectRuleData.collectRules[0].rule;
        for (var _i = 0, rule_1 = rule; _i < rule_1.length; _i++) {
            var obj = rule_1[_i];
            var group = new eui.Group();
            var flag = new eui.Image();
            if (obj.count > 0) {
                flag.source = '立牌_png';
                group.addChild(flag);
                var nameLab = new eui.Label();
                nameLab.width = 77;
                nameLab.height = 32;
                nameLab.textAlign = 'center';
                nameLab.verticalAlign = 'middle';
                nameLab.fontFamily = 'Helvetica';
                nameLab.textColor = 0x4a2f09;
                if (obj.name.length > 3) {
                    nameLab.size = 16;
                }
                else {
                    nameLab.size = 22;
                }
                nameLab.text = obj.name;
                group.addChild(nameLab);
                nameLab.x = 0;
                nameLab.y = 0;
            }
            else {
                flag.source = '地点锁_png';
                group.addChild(flag);
                flag.x = 24;
                flag.y = 20;
            }
            this.flagGroup.addChild(group);
            if (mapPosCFG[this.curMapName][obj.name]) {
                group.x = mapPosCFG[this.curMapName][obj.name][0];
                group.y = mapPosCFG[this.curMapName][obj.name][1];
            }
        }
    };
    /**
     * 按下地图
     */
    TourPanel.prototype.onDown_Map = function (e) {
        this.startPos.x = e.stageX;
        this.startPos.y = e.stageY;
    };
    /**
     * 移动地图
     */
    TourPanel.prototype.onMove_Map = function (e) {
        var deviationX = this.startPos.x - e.stageX;
        var deviationY = this.startPos.y - e.stageY;
        if (this.mapUnlock.x - deviationX > this.maskGroup.x) {
            this.mapUnlock.x = this.maskGroup.x;
        }
        else if (this.mapUnlock.x - deviationX < (this.maskGroup.x + this.maskGroup.width) - this.mapUnlock.width) {
            this.mapUnlock.x = (this.maskGroup.x + this.maskGroup.width) - this.mapUnlock.width;
        }
        else {
            this.mapUnlock.x = this.mapUnlock.x - deviationX;
        }
        if (this.mapUnlock.y - deviationY > this.maskGroup.y) {
            this.mapUnlock.y = this.maskGroup.y;
        }
        else if (this.mapUnlock.y - deviationY < (this.maskGroup.y + this.maskGroup.height) - this.mapUnlock.height) {
            this.mapUnlock.y = (this.maskGroup.y + this.maskGroup.height) - this.mapUnlock.height;
        }
        else {
            this.mapUnlock.y = this.mapUnlock.y - deviationY;
        }
    };
    /**
     * 打开相册界面
     */
    TourPanel.prototype.onClick_albumBtn = function (e) {
        var _this = this;
        if (!this.isUnLock) {
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, ['地图还未解锁']);
            return;
        }
        NetManager_1.NetManager.ins.getCollectGoodsInfo(function () {
            _this.hidePanel();
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.ALBUM_PANEL);
        }, window['collectRuleIdList'] ? window['collectRuleIdList'][this.curMapName == '中国' ? 0 : (this.curMapName == '亚洲' ? 1 : 2)] : 1);
        //点击埋点，相册
        var dpm = Buried_1.Buried.connectDpm(110, 2, 1);
        var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
        var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
        var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
        NetManager_1.NetManager.ins.clickLog(exposure);
    };
    /**
     * 出游
     */
    TourPanel.prototype.onClick_tourBtn = function (e) {
        if (!this.isUnLock) {
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, ['地图还未解锁']);
            return;
        }
        console.log('出游');
        this.surePanel.visible = true;
        this.tourCost = window['tourCost'] ? window['tourCost'] : 0;
        this.costTxt.text = '即将花费' + this.tourCost + '金币出游';
        this.txt.text = '收集旅游相册，记录足迹';
        //点击埋点，出游
        var dpm = Buried_1.Buried.connectDpm(110, 2, 2);
        var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
        var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
        var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
        NetManager_1.NetManager.ins.clickLog(exposure);
        if (this.guideBack) {
            this.showGuide(7);
        }
    };
    /**
     * 确认出游
     * @param e
     */
    TourPanel.prototype.onClick_sureBtn = function (e) {
        this.onHidePop();
        if (DataManager_1.DataManager.ins.petIndexData.credits < this.tourCost) {
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, ['金币不足']);
            return;
        }
        var mapType;
        if (this.curMapName == '中国') {
            mapType = 1;
        }
        else if (this.curMapName == '亚洲') {
            mapType = 2;
        }
        else if (this.curMapName == '欧洲') {
            mapType = 3;
        }
        NetManager_1.NetManager.ins.petGoout(this.petGoout_Back.bind(this), DataManager_1.DataManager.ins.petIndexData.activityId, DataManager_1.DataManager.ins.petHomeInfoData.petId, mapType);
        //点击埋点，确认出游
        var dpm = Buried_1.Buried.connectDpm(110, 3, 1);
        var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
        var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
        var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
        NetManager_1.NetManager.ins.clickLog(exposure);
        if (this.guideBack) {
            this.guideBack(8);
        }
    };
    TourPanel.prototype.petGoout_Back = function (success) {
        if (!success) {
            return;
        }
        console.log('出游回调成功');
        GDispatcher_1.GDispatcher.dispatchEvent('onTour');
        this.hidePanel();
    };
    /**
     * 隐藏出游确认弹框
     */
    TourPanel.prototype.onHidePop = function () {
        this.surePanel.visible = false;
    };
    TourPanel.prototype.initEvents = function () {
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        for (var i = 0; i < 3; i++) {
            this['tabBtn_' + i].addEventListener(egret.TouchEvent.TOUCH_TAP, this.changeMap, this);
        }
        this.controlGroup.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onDown_Map, this);
        this.controlGroup.addEventListener(egret.TouchEvent.TOUCH_MOVE, this.onMove_Map, this);
        this.albumBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_albumBtn, this);
        this.tourBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_tourBtn, this);
        this.popCloseBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onHidePop, this);
        this.sureBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_sureBtn, this);
    };
    TourPanel.prototype.removeEvents = function () {
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        for (var i = 0; i < 3; i++) {
            this['tabBtn_' + i].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.changeMap, this);
        }
        this.controlGroup.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onDown_Map, this);
        this.controlGroup.removeEventListener(egret.TouchEvent.TOUCH_MOVE, this.onMove_Map, this);
        this.albumBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_albumBtn, this);
        this.tourBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_tourBtn, this);
        this.popCloseBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onHidePop, this);
        this.sureBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_sureBtn, this);
    };
    TourPanel.prototype.showGuide = function (index) {
        this.hideGuide();
        if (!this.guideLayer) {
            this.guideLayer = new GuidePanel_1.default();
            this.addChild(this.guideLayer);
        }
        var x;
        var y;
        var w;
        var h;
        if (index == 6) {
            x = this.tourBtn.x;
            y = this.height - this.tourBtn.bottom;
            w = 422;
            h = 125;
        }
        else if (index == 7) {
            x = this.sureBtn.x;
            y = this.surePanel.y + this.sureBtn.y;
            w = 422;
            h = 115;
        }
        this.guideLayer.updateData(index, x, y, w, h);
    };
    TourPanel.prototype.hideGuide = function () {
        if (this.guideLayer) {
            this.guideLayer.dispose();
            this.removeChild(this.guideLayer);
            this.guideLayer = null;
        }
    };
    return TourPanel;
}(Panel_1.default));
exports.default = TourPanel;
__reflect(TourPanel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/src/tourPanel/TourPanel\".TourPanel");
//# sourceMappingURL=TourPanel.js.map