import ComponentBase from "../ShootPlanet/MComponents/MComponentBase";
import { deltaH } from "../Main";

export default class ShareGuide extends ComponentBase {
    private static _parent: eui.UILayer;
    private static _instance: ShareGuide;
    public waitImg: eui.Image;
    static get instace(): ShareGuide {
        return ShareGuide._instance || (ShareGuide._instance = new ShareGuide());
    }
    constructor() {
        super();
        this.horizontalCenter = 0;
        // this.verticalCenter = 0;
        
    }

    show() {
        ShareGuide._parent.addChild(this);
        if (this.skin && !this.hasEventListener(egret.TouchEvent.TOUCH_TAP)) {
            this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_this, this);
        }

        ShareGuide._parent.visible = true;
    }

    hide() {
        if (ShareGuide._parent.getChildIndex(this) == -1) return;

        ShareGuide._parent.removeChild(this);
        if (this.hasEventListener(egret.TouchEvent.TOUCH_TAP)) {
            this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_this, this);
        }

        if (ShareGuide._parent.numChildren == 0) {
            ShareGuide._parent.visible = false;
        }
    }

    static init(parent: eui.UILayer) {
        ShareGuide._parent = parent;
    }

    onSkinComplete(): any {
        super.onSkinComplete();
        if (!this.hasEventListener(egret.TouchEvent.TOUCH_TAP))
            this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_this, this);
    }

    onTap_this() {
        this.hide()
    }

    public get skinKey() { return 'ShareGuide' }
}
