import ComponentBase from "../ShootPlanet/MComponents/MComponentBase";

export default class Loading extends ComponentBase {
    private static _parent: eui.UILayer;
    private static _instance: Loading;
    public waitImg: eui.Image;
    static get instace(): Loading {
        return Loading._instance || (Loading._instance = new Loading());
    }
    constructor() {
        super();
        this.horizontalCenter = 0;
        this.verticalCenter = 0;
        //加个透明的,阻止事件
        var bg: egret.Shape = new egret.Shape();
        bg.graphics.beginFill(0x000000, 0);
        bg.graphics.drawRect(0, 0, 750, 1624);
        bg.graphics.endFill();
        bg.touchEnabled = true;
        this.addChildAt(bg, 0);
    }

    show() {
        Loading._parent.addChild(this);
        if (this.skin && !this.hasEventListener(egret.Event.ENTER_FRAME)) {
            this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
        }

        Loading._parent.visible = true;
    }

    hide() {
        if (Loading._parent.getChildIndex(this) == -1) return;

        Loading._parent.removeChild(this);
        if (this.hasEventListener(egret.Event.ENTER_FRAME)) {
            this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
        }

        if (Loading._parent.numChildren == 0) {
            Loading._parent.visible = false;
        }
    }

    static init(parent: eui.UILayer) {
        Loading._parent = parent;
    }

    onSkinComplete(): any {
        super.onSkinComplete();
        if (!this.hasEventListener(egret.Event.ENTER_FRAME))
            this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    onEnterFrame() {
        this.waitImg.rotation += 5;
    }

    public get skinKey() { return 'Loading' }
}
