import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import { deltaH } from "../../Main";


export default class TdCodePanel extends Panel {
    get skinKey() { return "TdCodePanel" }
    public btnClose: MButton;


    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());
        if (!document.getElementById("tdCode")) {
            var tdCode = new Image();
            tdCode.src = window["tdCode"] || "//yun.duiba.com.cn/db_games/activity/shoot_planet_szrcb/tdCode.jpg";
            tdCode.style.position = "absolute";
            var b = (200 / 750 * document.body.clientWidth + 0.5) >> 0;
            tdCode.style.width = b + "px";
            var a = (document.body.clientWidth / 2 - b / 2 + 0.5) >> 0
            tdCode.style.left = a + "px";
            var aa = ((403 + deltaH) / this.stage.stageHeight * document.body.clientHeight + 0.5) >> 0;
            tdCode.style.top = aa + "px";
            tdCode.style.opacity = "1";
            document.body.appendChild(tdCode);
            tdCode.id = "tdCode";
        } else {
            document.getElementById("tdCode").style.display = "block";
        }
    }
    hidePanel() {
        super.hidePanel();
        if (document.getElementById("tdCode")) {
            document.getElementById("tdCode").style.display = "none";
        }
    }

}