import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import ShareGuide from "../../shareGuide/ShareGuide";
import MTimer from "../MComponents/MTimer";
import { NetUtils } from "../Global/NetUtils";
import Net from "../Global/Net";
import ToastPanel from "../MComponents/MToastPanel";
import SceneCtrl from "../MCtrls/MSceneCtrl";
import { MConfigs } from "../Global/MConfigs";
import PanelCtrl from "../MCtrls/MPanelCtrl";
import TaskMsgPanel from "./TaskMsgPanel";


//data的格式
var data = [
    {
        "type": "share",
        "status": 0  //0未完成，1已完成
    },
    {
        "type": "transfer",
        "status": 0
    },
    {
        "type": "mobileBank",
        "status": 0
    },
    {
        "type": "bindWechat",
        "status": 0
    }
]

export default class TaskPanel extends Panel {
    get skinKey() { return "TaskPanel" }
    public btnClose: MButton;
    public shareBtn: MButton;
    public taskBtn1: MButton;
    public taskBtn2: MButton;
    public taskBtn3: MButton;

    onSkinComplete() {
        super.onSkinComplete();

        //曝光埋点
        NetUtils.showLog(11);
        NetUtils.showLog(12);
        NetUtils.showLog(13);
        NetUtils.showLog(14);

        this.btnClose.onTap(this, () => this.hidePanel());
        //四个任务按钮的判断,逻辑待写
        var btns = [this.shareBtn, this.taskBtn1, this.taskBtn2, this.taskBtn3]
        for (var i = 0; i < btns.length; i++) {
            var data = this.data[i];
            btns[i].enabled = !data.status
        }
        //分享事件
        this.shareBtn.onTap(this, () => {
            //点击埋点
            NetUtils.clickLog(11);

            ShareGuide.instace.show();
            //直接延时，还是在回调里
            setTimeout(() => {
                const timestamp = NetUtils.getTimestamp();
                Net.sendPost(Net.Url.share, {
                    timestamp: timestamp,
                    token: NetUtils.md5(timestamp + "duiba4szrcb")
                }, () => {
                    ToastPanel.show("任务完成，次数+1");
                    this.shareBtn.enabled = false;
                    //怎么更新首页的次数
                    SceneCtrl.instance["_currentScene"]["updateTimes"]();
                }, () => { });
            }, 7000);
        });
        //事件
        for (let i = 1; i < btns.length; i++) {
            btns[i].onTap(this, () => {
                //点击埋点
                NetUtils.clickLog(11 + i);
                PanelCtrl.instance.show(TaskMsgPanel, { type: this.data[i].type });
                this.hidePanel();
            })
        }
    }
}