import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import { MConfigs } from "../Global/MConfigs";

const urls = {
    "transfer": "phone",    //开通手机号转账
    "mobileBank": "login",    //开通手机银行大众版
    "bindWechat": "bindWechat",  //微信动账通知绑定
}

export default class TaskMsgPanel extends Panel {
    get skinKey() { return "TaskMsgPanel" }
    public okBtn: MButton;
    public btnClose: MButton;

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());

        //跳转相应的链接
        this.okBtn.onTap(this, () => {
            //如果是绑定微信，直接跳
            if (urls[this.data.type] == "bindWechat") {
                location.href = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx80f9cc9f4b9da11f&redirect_uri=https://mall.wjrcb.com/app/appCustomer/weixinWbankLogin.htm?response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect"
            } else {
                //中间页
                location.href = MConfigs.appLink + urls[this.data.type];
            }

        });
    }
}