import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import { MConfigs } from "../Global/MConfigs";
import Net from "../Global/Net";



export default class RankPrizePanel extends Panel {
    get skinKey() { return "RankPrizePanel" }
    public btnClose: MButton;
    public recordBtn: MButton;
    public rankTxt: eui.Label;

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => {
            this.hidePanel()
            //发接口消除
            // Net.sendGet(Net.Url.remove, { type: "reward" }, (res) => { }, () => { return true })
        });

        //排行榜文案
        this.rankTxt.text = "恭喜勇士荣获第" + this.data.rank + "名";
        //一个奖品还是两个奖品,逻辑待写
        this.updataPrizes();
        //点击跳转
        this.recordBtn.onOnceTap(this, (resume) => {
            //发接口消除
            // Net.sendGet(Net.Url.remove, { type: "reward" }, (res) => { }, () => { return true })
            // resume();
            // setTimeout(() => {
                location.href = MConfigs.rewardRecordUrl;
            // }, 2000)
        });
    }

    updataPrizes() {
        var prizeIds = [];
        for (var i = 0; i < this.data.prizes.length; i++) {
            if (this.data.prizes[i]) prizeIds.push(this.data.prizes[i])
        }
        //一个奖品
        if (prizeIds.length == 1) {
            let p = new prizeItem();
            p.x = 275;
            p.y = 370;
            this.addChild(p);
            Net.sendGet(
                Net.Url.prizeInfo,
                { ids: prizeIds.join(",") },
                (res) => {
                    p.update(res.data[0])
                },
                //失败时，为了不弹toast
                () => { return true }
            )
        }
        //两个奖品
        else {
            let p1 = new prizeItem();
            p1.x = 275 - 107;
            p1.y = 370;
            this.addChild(p1);
            let p2 = new prizeItem();
            p2.x = 275 + 107;
            p2.y = 370;
            this.addChild(p2);
            Net.sendGet(
                Net.Url.prizeInfo,
                { ids: prizeIds.join(",") },
                (res) => {
                    p1.update(res.data[0])
                    p2.update(res.data[1])
                },
                //失败时，为了不弹toast
                () => { return true }
            )
        }
    }
}

class prizeItem extends eui.Component {
    prizeImage: eui.Image;
    prizeName: egret.TextField;
    constructor() {
        super();
        this.prizeImage = new eui.Image();
        this.prizeImage.width = 200;
        this.prizeImage.height = 200;
        this.addChild(this.prizeImage);
        this.prizeName = new eui.Label();
        this.prizeName.size = 24;
        this.prizeName.textColor = 0xd3cdff;
        this.prizeName.width = 200;
        this.prizeName.y = 220;
        this.prizeName.textAlign = egret.HorizontalAlign.CENTER;
        this.addChild(this.prizeName);
    }
    update(data) {
        this.prizeImage.source = data.icon;
        this.prizeName.text = data.name;
    }
}