import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import { GFun } from "../../../libs/tc/util/GFun";
import ToastPanel from "../MComponents/MToastPanel";
import Loading from "../../loading/Loading";
import Net from "../Global/Net";
import { NetUtils } from "../Global/NetUtils";
import SceneCtrl from "../MCtrls/MSceneCtrl";


// 0xff5e39
// 0x797979
export default class PhoneNumPanel extends Panel {
    get skinKey() { return "PhoneNumPanel" }
    public btnClose: MButton;
    public btnSubmit: MButton;
    public phoneNum: eui.EditableText;
    public codeNum: eui.EditableText;
    public msgBtn: eui.Label;

    private timeoutId;
    onSkinComplete() {
        super.onSkinComplete();

        //曝光埋点
        NetUtils.showLog(4);

        this.btnClose.onTap(this, () => this.hidePanel());
        //发送验证码
        this.msgBtn.onTap(this, () => {
            this.inputBtnAdapt();
            const phone = this.phoneNum.text;
            // console.log(phone)
            if (!(/^1[34578]\d{9}$/.test(phone))) {
                ToastPanel.show('请输入正确的手机号');
                return;
            }
            this.msgBtn.touchEnabled = false;
            //发接口
            Net.sendGet(
                Net.Url.sendCode,
                { mobile: phone },
                (res) => {
                    //文案修改，倒计时？
                    this.msgBtn.text = "已发送";
                    this.msgBtn.textColor = 0x797979;
                    //计时，60秒后还能
                    this.timeoutId = setTimeout(() => {
                        this.msgBtn.text = "发送验证码";
                        this.msgBtn.textColor = 0xff5e39
                        this.msgBtn.touchEnabled = true;
                    }, 60 * 1000)
                },
                () => {
                    //允许再次点击
                    this.msgBtn.touchEnabled = true;
                }
            )
        })
        //提交按钮
        this.btnSubmit.onTap(this, () => {
            //点击埋点
            NetUtils.clickLog(4);

            this.inputBtnAdapt();
            const code = this.codeNum.text;
            // console.log(code)
            if (!code) {
                ToastPanel.show('请输入正确的验证码');
                return;
            }
            Loading.instace.show();

            //发接口，带入验证码

            Net.sendGet(
                Net.Url.verifyCode,
                { code: code },
                (res) => {
                    Loading.instace.hide();
                    //验证成功，去掉计时器
                    clearTimeout(this.timeoutId);
                    //关闭自己
                    this.hidePanel();
                    //修改首页信息
                    SceneCtrl.instance["_currentScene"]["homePageData"].isLogin = true;
                },
                () => {
                    Loading.instace.hide();
                }
            )
        })
    }

    private enableMouseEvent(b: boolean) {
        this.msgBtn.touchEnabled = b;
        this.btnClose.touchEnabled = b;
        this.btnSubmit.touchEnabled = b;
    }

    inputBtnAdapt() {
        if (GFun.isIOS) {
            setTimeout(() => {
                const scrollHeight = document.documentElement.scrollTop || document.body.scrollTop || 0;
                window.scrollTo(0, Math.max(scrollHeight - 1, 0));
            }, 100)
        }
    }

    inputAdapt() {
        var u = navigator.userAgent, app = navigator.appVersion
        var isIOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
        if (isIOS) {
            setTimeout(() => {
                window["$"]("input").blur(function () {
                    if (isIOS) {
                        blurAdjust()
                        // alert("1231321233")
                    }
                });
            }, 50)
        }
        // 解决苹果不回弹页面
        function blurAdjust() {
            setTimeout(() => {
                // alert("1231321233")
                if (document.activeElement.tagName == 'INPUT' || document.activeElement.tagName == 'TEXTAREA') {
                    return
                }
                let result = 'pc';
                if (/(iPhone|iPad|iPod|iOS)/i.test(navigator.userAgent)) { //判断iPhone|iPad|iPod|iOS
                    result = 'ios'
                } else if (/(Android)/i.test(navigator.userAgent)) {  //判断Android
                    result = 'android'
                }

                if (result = 'ios') {
                    document.activeElement["scrollIntoViewIfNeeded"](true);
                }
            }, 100)
        }
    }
}

