import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import { MConfigs } from "../Global/MConfigs";
import PanelCtrl from "../MCtrls/MPanelCtrl";
import TaskPanel from "./TaskPanel";
import Net from "../Global/Net";
import Loading from "../../loading/Loading";

export default class NoTimesPanel extends Panel {
    get skinKey() { return "NoTimesPanel" }
    public okBtn: MButton;
    public btnClose: MButton;

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());

        this.okBtn.onTap(this, () => {
            this.hidePanel()
            //前往任务弹框
            Loading.instace.show();
            Net.sendGet(
                Net.Url.taskList,
                //参数
                undefined,
                //成功回调
                (res) => {
                    Loading.instace.hide();
                    PanelCtrl.instance.show(TaskPanel, res.data);
                },
                //失败回调
                () => { Loading.instace.hide(); });
        });
    }
}