import { Decorator } from "../Decorator/Decorator";
import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import MainScene from "../Scene/MainScene";
import Loading from "../../loading/Loading";
import SceneCtrl from "../MCtrls/MSceneCtrl";
import StartScene from "../Scene/StartScene";
import PanelCtrl from "../MCtrls/MPanelCtrl";
import UsePropsPanel from "./UsePropsPanel";
import ToastPanel from "../MComponents/MToastPanel";
import { MConfigs } from "../Global/MConfigs";
import Net from "../Global/Net";
import GameMgr from "../Mgr/GameMgr";
import ShareGuide from "../../shareGuide/ShareGuide";
import MTimer from "../MComponents/MTimer";
import { NetUtils } from "../Global/NetUtils";

@Decorator.ClassName("GameOverPanel")
@Decorator.OnUpdate
export default class GameOverPanel extends Panel implements Decorator.IDefaultCallback {
    public btnClose: MButton;
    public labelScore: eui.Label;
    public labelTopScore: eui.Label;
    public btnRestart: MButton;
    public btnShare: MButton;
    public shareMsg: eui.Image;
    // public btnUseProps: MButton;
    private context: MainScene;
    private timestamp: number = null;

    private hasShare: boolean

    constructor(data?) {
        super(data);
        this.timestamp = egret.getTimer();

    }

    init(context: MainScene) {
        this.context = context;
    }

    onUpdate() {
        // if (egret.getTimer() - this.timestamp > MConfigs.GameOverPanelStayTime) {
        //     this.onClose();
        // }
    }

    onNetError() {
        this.onClose();
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => {
            this.onClose();
        });

        //分数不该用接口里的？
        // this.labelScore.text = this.context.score.toString();
        // this.labelTopScore.text = (this.context.maxScore || this.context.score).toString()
        this.labelScore.text = this.data.finalScore + "";
        this.labelTopScore.text = (this.data.maxScore || this.data.finalScore) + ""

        this.btnRestart.onTap(this, () => {
            this.onClose();
        });
        this.btnShare.onTap(this, () => {
            //点击埋点
            NetUtils.clickLog(8);

            ShareGuide.instace.show();
            //已经点过了就return
            if (this.hasShare) return;
            //直接延时，还是在回调里
            MTimer.set(180, () => {
                const timestamp = NetUtils.getTimestamp();
                Net.sendPost(Net.Url.share, {
                    timestamp: timestamp,
                    token: NetUtils.md5(timestamp + "duiba4szrcb")
                }, () => {
                    this.hasShare = true;
                    ToastPanel.show("任务完成，次数+1");
                }, () => { });
            });
        });

        //区分显示按钮，文案  逻辑待写
        // 1、每局结束后，若次数已用完，且今日未分享，则出分享弹窗，点击按钮唤起分享面板
        // 2、若次数未用完，出得分弹窗，用户点击“再来一次”按钮，回到主页，开始新的一局
        // 3、若次数用完，且今日已分享，则出得分弹窗，点击“再来一次”按钮，回到主页，点击开始游戏，出toast“今日次数已用完”
        //没次数，且还能分享
        if (!this.data.leftTimes && this.data.leftShareTimes) {
            this.btnRestart.visible = false;
            this.btnShare.visible = true;
            this.shareMsg.visible = true;

            //曝光埋点
            NetUtils.showLog(7);
            NetUtils.showLog(8);
        } else {
            this.btnRestart.visible = true;
            this.btnShare.visible = false;
            this.shareMsg.visible = false;

            //曝光埋点
            NetUtils.showLog(6);
        }


        // this.btnUseProps.onTap(this, () => {
        //     PanelCtrl.instance.show<UsePropsPanel>(UsePropsPanel).init(
        //         this,
        //         this.context,
        //         (id) => {
        //             if (typeof id == "string") { //使用的是加分卡
        //                 this.context.finalSubmit(id, () => {
        //                     ToastPanel.show("加分成功", true, () => {
        //                         PanelCtrl.instance.closeAll();
        //                         SceneCtrl.instance.change(StartScene);
        //                     });
        //                 });
        //             } else { //使用的是复活卡
        //                 this.hidePanel();
        //             }
        //         }
        //     );
        // });
    }

    private onClose() {
        PanelCtrl.instance.closeAll();
        // this.context.finalSubmit(undefined, () => {
        SceneCtrl.instance.change(StartScene);
        // });
    }
}