import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import { MConfigs } from "../Global/MConfigs";
import Net from "../Global/Net";
import { NetUtils } from "../Global/NetUtils";

export default class DailyPrizePanel extends Panel {
    get skinKey() { return "DailyPrizePanel" }
    public recordBtn: MButton;
    public btnClose: MButton;
    prizeImage: eui.Image;
    prizeName: eui.Label;

    onSkinComplete() {
        super.onSkinComplete();

        //曝光埋点
        NetUtils.showLog(9);

        this.btnClose.onTap(this, () => this.hidePanel());

        Net.sendGet(
            Net.Url.prizeInfo,
            { ids: this.data.prizeId + "" },
            (res) => {
                var data = res.data[0];
                this.prizeImage.source = data.icon;
                this.prizeName.text = "恭喜您抽中\n" + data.name;
            },
            () => { return true }
        )

        //链接到
        this.recordBtn.onTap(this, () => {
            location.href = MConfigs.rewardRecordUrl;
        });
    }
}