import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import { getResPath } from "../Global/GUtils";
import Loading from "../../loading/Loading";
import PanelCtrl from "../MCtrls/MPanelCtrl";
import DailyPrizePanel from "./DailyPrizePanel";
import Net, { errorCodeMsg } from "../Global/Net";
import ToastPanel from "../MComponents/MToastPanel";
import SceneCtrl from "../MCtrls/MSceneCtrl";



const parser = new SVGA.Parser();
export const twoBox = {};
const twoBoxName = ["closedBox", "openBox"]

export function loadSvga(name: string) {
    return new Promise(function (resolve, reject) {
        parser.load(getResPath() + "resource/assets/svga/" + name + ".svga", (videoItem) => {
            twoBox[name] = new SVGA.EgretMovieClip(videoItem);
            twoBox[name].y = -200;
            resolve()
        })
    })
}
//先加载
loadSvga(twoBoxName[0])//.then()
loadSvga(twoBoxName[1])//.then()



export default class DailyLotPanel extends Panel {
    get skinKey() { return "DailyLotPanel" }
    public lotBtn: MButton;
    public btnClose: MButton;


    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());

        if (!twoBox["closedBox"]) {
            Loading.instace.show();
            Promise.all([loadSvga("closedBox"), loadSvga("openBox")]).then(() => {
                Loading.instace.hide();
                this.addChild(twoBox["closedBox"]);
                this.lotEvent();
            })
        } else {
            this.addChild(twoBox["closedBox"])
            this.lotEvent();
        }

        //判断下，按钮 1可抽奖，2不可抽奖
        if (this.data.lotteryStatus == 2) {
            this.lotBtn.enabled = false;
        } else {
            this.lotBtn.enabled = true;;
        }
    }

    private lotEvent() {
        this.lotBtn.onTap(this, () => {
            //0的情况
            if (this.data.lotteryStatus == 0) {
                ToastPanel.show("今日还未参与游戏")
                return
            }
            this.enableMouseEvent(false);
            //开下一个，移除前一个
            this.removeChild(twoBox["closedBox"])
            this.addChild(twoBox["openBox"]);
            var aaa: SVGA.EgretMovieClip = twoBox["openBox"];
            aaa.startAniRange(1, aaa.totalFrames, 1, () => {
                //发送接口，根据情况打开中奖非中奖弹框,还有异常情况 
                Net.sendGet(
                    Net.Url.lottery,
                    { type: 0 },//0每日抽奖，1
                    //成功
                    (res) => {
                        //修改下每日抽奖状态，反正每日一次
                        SceneCtrl.instance["_currentScene"]["homePageData"].lotteryStatus = 2;
                        //隐藏抽奖弹框
                        this.hidePanel();
                        //没抽中。弹toast
                        if (res.data.prizeId == "thanks") {
                            ToastPanel.show("您未中奖，再接再厉吧~")
                        }
                        //抽中，弹中奖弹框
                        else {
                            PanelCtrl.instance.show(DailyPrizePanel, { prizeId: res.data.prizeId })
                        }
                    },
                    //失败
                    (res) => {
                        //没有数据，网络问题，允许再次点击
                        if (!res) {
                            this.enableMouseEvent(true);
                        } else {
                            this.hidePanel();
                        }
                    }
                );
            })
        });
    }

    private enableMouseEvent(b: boolean) {
        this.lotBtn.touchEnabled = b;
        this.btnClose.touchEnabled = b;
    }
}