import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import { twoBox, loadSvga } from "./DailyLotPanel";
import Loading from "../../loading/Loading";
import Net from "../Global/Net";
import ToastPanel from "../MComponents/MToastPanel";
import PanelCtrl from "../MCtrls/MPanelCtrl";
import ActOverPrizePanel from "./ActOverPrizePanel";
import ActOverNoPrizePanel from "./ActOverNoPrizePanel";
import { NetUtils } from "../Global/NetUtils";



export default class ActOverLotPanel extends Panel {
    get skinKey() { return "ActOverLotPanel" }
    public lotBtn: MButton;
    public btnClose: MButton;

    onSkinComplete() {
        super.onSkinComplete();

        //曝光埋点
        NetUtils.showLog(10);

        this.btnClose.onTap(this, () => this.hidePanel());
        if (!twoBox["closedBox"]) {
            Loading.instace.show();
            Promise.all([loadSvga("closedBox"), loadSvga("openBox")]).then(() => {
                Loading.instace.hide();
                this.addChild(twoBox["closedBox"]);
                this.lotEvent();
            })
        } else {
            this.addChild(twoBox["closedBox"])
            this.lotEvent();
        }

        //判断下，按钮 1可抽奖，2不可抽奖
        if (this.data.lotteryEndStatus == 2) {
            this.lotBtn.enabled = false;
        } else {
            this.lotBtn.enabled = true;;
        }
    }

    private lotEvent() {
        this.lotBtn.onTap(this, () => {
            this.enableMouseEvent(false);
            //开下一个，移除前一个
            this.removeChild(twoBox["closedBox"])
            this.addChild(twoBox["openBox"]);
            var aaa: SVGA.EgretMovieClip = twoBox["openBox"];
            aaa.startAniRange(1, aaa.totalFrames, 1, () => {
                //发送接口，根据情况打开中奖非中奖弹框,还有异常情况 
                Net.sendGet(
                    Net.Url.lottery,
                    { type: 1 },//0每日抽奖，1活动结束抽奖
                    //成功
                    (res) => {
                        //隐藏抽奖弹框
                        this.hidePanel();
                        //没抽中。
                        if (res.data.prizeId == "thanks") {
                            PanelCtrl.instance.show(ActOverNoPrizePanel)
                        }
                        //抽中，弹中奖弹框
                        else {
                            PanelCtrl.instance.show(ActOverPrizePanel, { prizeId: res.data.prizeId })
                        }
                    },
                    //失败
                    (res) => {
                        //没有数据，网络问题，允许再次点击
                        if (!res) {
                            this.enableMouseEvent(true);
                        } else {
                            this.hidePanel();
                        }
                    }
                );
            })
        });
    }

    private enableMouseEvent(b: boolean) {
        this.lotBtn.touchEnabled = b;
        this.btnClose.touchEnabled = b;
    }
}