import Panel from "../MViews/MPanel";
import ComponentBase from "./MComponentBase";
import { Decorator } from "../Decorator/Decorator";

interface TweenEffect {
    in: {
        type: number,
        duration?: number
    },
    keepDuration: number,
    out: {
        type: number,
        duration?: number
    }
}

@Decorator.Skin("ToastPanel")
export default class ToastPanel extends eui.Component implements Decorator.ISkin {
    public static TweenEffectType = {
        None: 0,
        Fade: 1,
        Scale: 2
    }

    public labelMsg: eui.Label;
    private readonly margin = 68;
    private tweenEffect: TweenEffect = {
        in: {
            type: ToastPanel.TweenEffectType.Scale,
            duration: 200
        },
        keepDuration: 800,
        out: {
            type: ToastPanel.TweenEffectType.Fade,
            duration: 300
        }
    }

    private msg: string = "";
    public onVanished: () => void;


    constructor(msg: string) {
        super();
        this.msg = msg;
        this.horizontalCenter = 0;
        this.verticalCenter = 0;
    }

    public static parent: eui.UILayer = null;

    public static show(msg: string, touchEnabled: boolean = false, onVanished?: () => void) {
        if (ToastPanel.parent) {
            let panel = new ToastPanel(msg);
            if (touchEnabled) {
                ToastPanel.parent.touchEnabled = true;
                panel.onVanished = () => {
                    onVanished && onVanished();
                    //TODO: 多个toast重叠显示时会有问题
                    ToastPanel.parent.touchEnabled = false;
                }
            }
            ToastPanel.parent.addChild(panel);
        } else {
            console.warn("the parent of ToastPanel is null");
        }
    }

    onSkinComplete() {
        this.labelMsg.text = this.msg;
        this.labelMsg.validateSize();
        this.width = this.labelMsg.width + 2 * this.margin;

        let inProps: object = {};
        switch (this.tweenEffect.in.type) {
            case ToastPanel.TweenEffectType.Scale:
                this.scaleX = 0;
                this.scaleY = 0;
                inProps = { scaleX: 1, scaleY: 1 };
                break;

            case ToastPanel.TweenEffectType.Fade:
                this.alpha = 0;
                inProps = { alpha: 1 };
                break;

            default:
                break;
        }

        let outProps: object = {};
        switch (this.tweenEffect.out.type) {

            case ToastPanel.TweenEffectType.Scale:
                outProps = { scaleX: 0, scaleY: 0 };
                break;

            case ToastPanel.TweenEffectType.Fade:
                outProps = { alpha: 0 };
                break;
            default:
                break;
        }

        egret.Tween.get(this)
            .to(inProps, this.tweenEffect.in.duration || 0)
            .wait(this.tweenEffect.keepDuration)
            .to(outProps, this.tweenEffect.out.duration || 0, egret.Ease.quintOut).call(() => {
                this.destroy();
                this.onVanished && this.onVanished();
            });
    }
}