import { NetManager } from "../../../libs/tw/manager/NetManager";
import ToastPanel from "../MComponents/MToastPanel";
import Loading from "../../loading/Loading";
import SceneCtrl from "../MCtrls/MSceneCtrl";
import StartScene from "../Scene/StartScene";
import PanelCtrl from "../MCtrls/MPanelCtrl";
import { NetUtils } from "./NetUtils";
import { restart } from "./GUtils";

const projectId = NetUtils.getProjectId();
export default class Net {
    public static cache: object = {};

    /**
     * 
     * @param uri URL
     * @param param 参数
     * @param onSuccess 返回成功时的回调
     * @param onFail 返回失败是的回调 | 是否使用默认失败回调函数
     * @param pollingCheck 每次轮询回调
     * @param pollingCount 轮询最大次数
     */
    public static sendGet(uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        this.mSend("get", uri, param, onSuccess, onFail, pollingCheck, pollingCount);
    }

    /**
     * 
     * @param uri URL
     * @param param 参数
     * @param onSuccess 返回成功时的回调
     * @param onFail 返回失败是的回调 | 是否使用默认失败回调函数
     * @param pollingCheck 每次轮询回调
     * @param pollingCount 轮询最大次数
     */
    public static sendPost(uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        this.mSend("post", uri, param, onSuccess, onFail, pollingCheck, pollingCount);
    }

    private static mSend(type: string, uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        if (pollingCheck) {
            Loading.instace.show();
        }

        NetManager.ins.send({
            name: uri,
            uri: uri,
            type: type,
            dataType: 'json',
            param: param,
            callback: (success: any, res: any) => {
                Net.cache[uri] = res;

                if (pollingCheck) {
                    Loading.instace.hide();
                }

                if (success) {
                    // console.log("response", uri, res);
                    onSuccess(res);
                } else {
                    // console.warn("response", uri, res);

                    let errorMsg = res && (
                        (
                            res["desc"] || res["message"]
                        )
                        || (
                            (
                                res["code"] && (errorCodeMsg[res["code"] + ""] || "network error:" + res["code"])
                            )
                            || "网络异常"//"network error"
                        )
                    )
                        || "网络异常"//"network error";

                    if (typeof onFail == "function") {
                        if (!onFail(res)) { //若客户没有处理错误码，怎么默认显示错误消息或描述文字的弹窗
                            ToastPanel.show(errorMsg);
                        }
                    } else {
                        if (typeof onFail == "boolean" && onFail == true) {
                            Net.defaultOnFail && Net.defaultOnFail(res);
                        }
                        ToastPanel.show(errorMsg);
                    }
                }
            },
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        });
        // console.log("requset", uri, param);
    }

    public static defaultOnFail: (res: any) => void = () => {
        SceneCtrl.instance.change(StartScene);
        PanelCtrl.instance.closeAll();
        Loading.instace.hide();
    }

    public static urlReplace() {
        for (let i of Object.keys(Net.Url)) {
            for (let j of Object.keys(Net.urlReplaceConfig)) {
                Net.Url[i] = Net.Url[i].replace(new RegExp(j, "g"), Net.urlReplaceConfig[j]);
            }
        }
    }

    private static urlReplaceConfig = {
        "{projectId}": projectId
    }

    public static readonly Url = {
        signData: "/projectx/{projectId}/join_1/data.do",
        signIn: "/projectx/{projectId}/join_1/join.do",
        queryProps: "/projectx/{projectId}/scoring_1/spData.do",


        revive: "/projectx/{projectId}/scoring_1/revive.do",


        visit: "/projectx/{projectId}/scoring_1/visit.do",
        taskData: "/projectx/{projectId}/join_2/data.do",
        taskComplete: "/projectx/{projectId}/join_2/join.do",
        rankListOld: "/hdtool/rank/recentRankListNew",


        //本次苏州农商行接口
        rankInfo: "/projectx/{projectId}/scoring_1/userInfo.do",
        queryRankListData: "/projectx/{projectId}/getRanking.query",
        queryNickname: "/projectx/{projectId}/scoring_1/userInfoList.do",
        start: "/projectx/{projectId}/scoring_1/start.do",
        constantSubmit: "/projectx/{projectId}/scoring_1/push.do",
        finalSubmit: "/projectx/{projectId}/scoring_1/submit.do",
        homePage: "/projectx/{projectId}/join_1/join.do",
        taskList: "/projectx/{projectId}/join_1/list.do",
        prizeInfo: "/projectx/{projectId}/prize.query",
        share: "/projectx/{projectId}/join_1/share.do",
        remove: "/projectx/{projectId}/join_1/remove.do",
        lottery: "/projectx/{projectId}/join_2/join.do",
        getWechatUserNew: "/wechatThirdParty/getWechatUserNew",
        sendCode: "/projectx/{projectId}/join_1/sendSms.do",
        verifyCode: "/projectx/{projectId}/join_1/verifySms.do",
    }
}

export const errorCodeMsg = {
    "100001": "请先登录",
    "100101": "无免费次数",
}