import ComponentBase from "../Components/ComponentBase";
import Loading from "../Loading/Loading";
import MButton from "../MUI/MButton";

export default abstract class Panel extends ComponentBase {
    public hasMask: boolean = true;
    public onSkinLoaded: () => void;
    constructor(data?: any, hasMask: boolean = true) {
        super(data);
        this.hasMask = hasMask;
    }

    setShowAct(): void {
        this.alpha = 0;
        // this.y = document.body.clientHeight;
        // this.scaleY = 0;
        egret.Tween.get(this).to({ alpha: 1 }, 300).call(() => {
            this.onShowActComplete();
        });
    }

    /**@virtual */
    protected onShowActComplete() { }

    initEvents() {
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(
                btn => { if (btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        if (this.confirmBtns && this.confirmBtns.length > 0) {
            this.confirmBtns.forEach(
                btn => { if (btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        if (this.creditsOutBtns && this.creditsOutBtns.length > 0) {
            this.creditsOutBtns.forEach(
                btn => { if (btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.creditsOut, this) }
            )
        }

    }
    removeEvents() {
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(
                btn => { if (btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        if (this.confirmBtns && this.confirmBtns.length > 0) {
            this.confirmBtns.forEach(
                btn => { if (btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }

        if (this.creditsOutBtns && this.creditsOutBtns.length > 0) {
            this.creditsOutBtns.forEach(
                btn => { if (btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.creditsOut, this) }
            )
        }
    }

    protected onSkinComplete() {
        super.onSkinComplete();
        Loading.instace.hide();
        this.setShowAct();

        this.onSkinLoaded && this.onSkinLoaded();
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    protected get confirmBtns(): eui.Button[] { return [this['confirmBtn']] }
    protected get creditsOutBtns(): eui.Button[] { return [this['creditsOutBtn']] }

    onTouchTap(): any {
        this.hidePanel();
    }

    hidePanel() {
        this.dispatchEvent(new egret.Event('onDestroy'));
        this.removeEvents();
    }

    creditsOut() {
        this.dispatchEvent(new egret.Event('onCreditsOut'));
        this.removeEvents();
    }

}