import { Decorator } from "../Decorator/Decorator";
import Panel from "../views/Panel";
import MButton from "../MUI/MButton";
import MainScene from "../Scene/MainScene";
import Loading from "../Loading/Loading";
import SceneCtrl from "../Ctrls/SceneCtrl";
import StartScene from "../Scene/StartScene";
import PanelCtrl from "../Ctrls/PanelCtrl";
import UsePropsPanel from "./UsePropsPanel";
import ToastPanel from "../Components/ToastPanel";
import { MConfigs } from "../Global/MConfigs";

@Decorator.ClassName("GameOverPanel")
@Decorator.OnUpdate
export default class GameOverPanel extends Panel implements Decorator.IDefaultCallback {
    public btnClose: MButton;
    public labelScore: eui.Label;
    public labelTopScore: eui.Label;
    public btnRestart: MButton;
    public btnUseProps: MButton;
    private context: MainScene;
    private timestamp: number = null;

    constructor() {
        super();
        this.timestamp = egret.getTimer();
    }

    init(context: MainScene) {
        this.context = context;
    }

    onUpdate() {
        if (egret.getTimer() - this.timestamp > MConfigs.GameOverPanelStayTime) {
            this.onClose();
        }
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => {
            this.onClose();
        });

        this.labelScore.text = this.context.score.toString();
        const maxScore = this.context.maxScore;
        this.labelTopScore.text = typeof this.context.maxScore == "number" ? maxScore.toString() : "-";

        this.btnRestart.onTap(this, () => {
            this.onClose();
        });

        this.btnUseProps.onTap(this, () => {
            PanelCtrl.instance.show<UsePropsPanel>(UsePropsPanel).init(
                this,
                this.context,
                (id) => {
                    if (typeof id == "string") { //使用的是加分卡
                        this.context.finalSubmit(id, () => {
                            ToastPanel.show("加分成功", true, () => {
                                PanelCtrl.instance.closeAll();
                                SceneCtrl.instance.change(StartScene);
                            });
                        });
                    } else { //使用的是复活卡
                        this.hidePanel();
                    }
                }
            );
        });
    }

    private onClose() {
        PanelCtrl.instance.closeAll();
        this.context.finalSubmit(undefined, () => {
            SceneCtrl.instance.change(StartScene);
        });
    }
}