import Panel from "../views/Panel";
import MButton from "../MUI/MButton";

interface DataType {
    title: string,
    content: string,
    btnText: string,
};

export default class CommonPanel extends Panel {
    get skinKey() { return "CommonPanel" }
    public btn: MButton;
    public labelTitle: eui.Label;
    public labelContent: eui.Label;
    public btnClose: MButton;

    data: DataType;

    init(data: DataType) {
        this.data = data;
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());
        this.labelTitle.text = this.data.title;
        this.labelContent.text = this.data.content;
        this.btn.label = this.data.btnText;
    }
}