import Panel from "../views/Panel";
import Loading from "../Loading/Loading";
export default class PanelCtrl {
    private _parent: eui.UILayer;
    private _mask: egret.Shape;
    private hasMaskCount = 0;
    private stack: Panel[] = [];


    static _instance: PanelCtrl;
    static get instance() {
        return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl())
    }

    init(parent: eui.UILayer) {
        this._parent = parent;
        let mask = new egret.Shape();
        mask.graphics.beginFill(0, 0.8);
        mask.graphics.drawRect(0, 0, this._parent.width, this._parent.height);
        mask.graphics.endFill();
        mask.touchEnabled = false;
        this._parent.addChild(mask);
        this._mask = mask;
    }

    closeAll() {
        this.stack.forEach(e => e.hidePanel());
    }

    show(cls: any, data?: any, hasMask: boolean = true) {
        Loading.instace.show();
        const panel: Panel = new cls(data, hasMask);
        this._current = panel;
        this.add(panel);
        this._parent.visible = true;
        this.stack.push(panel);

        panel.onSkinLoaded = () => {
            if (panel.hasMask) {
                this.hasMaskCount++;
            }
            this.updateView();
        }
    }

    private updateView() {
        if (this.hasMaskCount > 0) {
            this._mask.visible = true;
        } else {
            this._mask.visible = false;
        }

        for (let i = 0; i < this.stack.length; i++) {
            if (i < this.stack.length - 1) {
                this.stack[i].visible = false;
            } else {
                this.stack[i].visible = true;
            }
        }

        if (this._parent.numChildren == 1) {
            this._parent.visible = false;
        }
    }

    /**
     * 防止连点
     * @param targe 可交互对象
     * @param dtime 延时默认500ms
     */
    public btnDelay(targe: any, dtime: number = 500) {
        targe.touchEnabled = false;
        setTimeout(() => {
            targe.touchEnabled = true;
        }, dtime);
    }

    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
        panel.addEventListener('onCreditsOut', this.onCreditsOut, this);
    }

    private remove(panel: Panel) {
        this._parent.removeChild(panel);
        this.stack = this.stack.filter(e => e != panel);
    }

    private onPanelHide(e: egret.Event) {
        const panel = e.target as Panel;
        if (panel.hasMask) {
            this.hasMaskCount--;
        }
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        panel.removeEventListener('onCreditsOut', this.onCreditsOut, this);
        this.remove(panel);

        this.updateView();
    }

    private onCreditsOut(e: egret.Event) {
        if (!window['CFG'] || !window['CFG'].appInfo) return;
        window.location.href = window['CFG'].appInfo.earnCreditsUrl;
    }


    private _current: Panel;

    closeCurrent() {
        if (this._current)
            this.remove(this._current);
    }
}