export default class MEvent<T extends Function>{
    private list: T[] = [];
    public add(callback: T) {
        this.list.push(callback);
    }
    public remove(callback: T) {
        this.list = this.list.remove(callback);
    }

    public call(...args: any[]) {
        let removeList = [];

        this.list.forEach(callback => {
            callback(...args, () => {
                removeList.push(callback);
            });
        });

        this.list = this.list.filter(e => {
            for (let i of removeList) {
                if (i === e) {
                    return false;
                }
            }
            return true;
        });
    }
}