export default class MArray<T>{
    public data: T[] = [];
    public get(index: number): T {
        if (index < 0 || index > this.data.length - 1) {
            console.error(`array out of bounds: ${index} out of [0, ${this.data.length - 1}]`);
            return null;
        }

        return this.data[index];
    }

    public push(element: T) {
        this.data.push(element);
    }

    public get length() {
        return this.data.length;
    }

    public clear() {
        this.data = [];
    }
}