import Panel from "../views/Panel";
import MButton from "../MUI/MButton";
import Net from "../Global/Net";
import SignInItem from "./SignInItem";
import { Decorator } from "../Decorator/Decorator";
import PanelCtrl from "../Ctrls/PanelCtrl";
import { MConfigs } from "../Global/MConfigs";
import { ThroughSubmitData } from "../../libs/tw/data/custom/throughSubmit/ThroughSubmitData";
import { NetUtils } from "../Global/NetUtils";

export default class SignInPanel extends Panel {
    get skinKey() { return "SignInPanel" }
    @Decorator.LightRotate(7000)
    public light: eui.Image;
    public imgSignInDiabled: eui.Image;
    public btnSignIn: MButton;
    public btnClose: MButton;
    public dataGroup: eui.DataGroup;

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());
        this.btnSignIn.onTap(this, () => {
            let timestamp = NetUtils.getTimestamp();
            Net.sendPost(Net.Url.signIn, {
                timestamp: timestamp,
                token: NetUtils.md5(timestamp + "dui88")
            }, (res) => {
                PanelCtrl.instance.show(SignSuccessPanel, {
                    coin: res.data.rewardCoins,
                    cardId: res.data.rewardSpId
                });
                this.refresh();
            });
        });

        this.refresh();
    }

    private refresh() {
        Net.sendGet(Net.Url.signData, undefined, (res) => {
            let rewardList = res.data.rewardList as Array<any>;
            let cycleDays = res.data.cycleDays as number;

            let arr: {
                cardId: string,
                isSigned: boolean,
                dayNum: number
            }[] = [];
            for (let i = 0; i < rewardList.length; i++) {
                let isSign: boolean = false;
                if (i + 1 <= cycleDays) {
                    isSign = true;
                }
                arr.push({
                    cardId: rewardList[i]["spId"],
                    isSigned: isSign,
                    dayNum: i + 1
                });
            }
            this.dataGroup.dataProvider = new eui.ArrayCollection(arr);
            this.dataGroup.itemRenderer = SignInItem;

            if (res.data.todaySignFlag) {
                this.imgSignInDiabled.visible = true;
            } else {
                this.btnSignIn.visible = true;
            }
        });
    }
}

class SignSuccessPanel extends Panel {
    get skinKey() { return "SignSuccessPanel" }
    @Decorator.LightRotate(7000)
    public light: eui.Image;
    public btnOk: MButton;
    public labelReward: eui.Label;
    public btnClose: eui.Button;
    data: {
        coin: number,
        cardId: string
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());
        this.btnOk.onTap(this, () => this.hidePanel());

        let str = "恭喜你获得\n";
        if (this.data.coin) {
            str += this.data.coin + "金币";
        }
        if (this.data.cardId) {
            str += MConfigs.props[this.data.cardId].name;
        }
        this.labelReward.text = str;
    }
}