import PoolMgr from "./PoolMgr";
import Ball from "../Global/Ball";
import PhycicsSystem from "../Game/PhycicsSystem";
import MTweenMgr from "../components/MTween";
import SoundMgr from "./SoundMgr";

export default class GameMgr {
    private static _instance: GameMgr = null;
    public static get instance(): GameMgr {
        if (!this._instance) {
            this._instance = new GameMgr();
        }

        return this._instance;
    }

    private _pause: boolean = false;
    public set pause(v: boolean) {
        this._pause = v;
        PhycicsSystem.instance.pause = this._pause;
        MTweenMgr.instance.pause = this._pause;
    }
    public get pause() {
        return this._pause;
    }

    public reviveSeq: number = 1;

    public start() {
        this.reviveSeq = 1;
        this.pause = false;
    }

    public hasClicked = false;
    public switchSound() {
        SoundMgr.instance.musicEnabled = !SoundMgr.instance.musicEnabled;
        SoundMgr.instance.effectEnabled = !SoundMgr.instance.effectEnabled;
    }
}