import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import ToastPanel from "../Components/ToastPanel";
import Loading from "../Loading/Loading";
import SceneCtrl from "../Ctrls/SceneCtrl";
import StartScene from "../Scene/StartScene";
import PanelCtrl from "../Ctrls/PanelCtrl";

export default class Net {
    public static cache: object = {};

    public static sendGet(uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        this.mSend("get", uri, param, onSuccess, onFail, pollingCheck, pollingCount);
    }
    public static sendPost(uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        this.mSend("post", uri, param, onSuccess, onFail, pollingCheck, pollingCount);
    }
    private static mSend(type: string, uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        if (pollingCheck) {
            Loading.instace.show();
        }

        NetManager.ins.send({
            name: uri,
            uri: Net.urlReplace(uri),
            type: type,
            dataType: 'json',
            param: param,
            callback: (success: any, res: any) => {
                Net.cache[uri] = res;

                if (pollingCheck) {
                    Loading.instace.hide();
                }

                if (success) {
                    console.log("response", uri, res);
                    onSuccess(res);
                } else {
                    console.warn("response", uri, res);

                    let errorMsg =
                        res && (
                            (
                                res["desc"] || res["message"]
                            )
                            || (
                                (
                                    res["code"] && "network error:" + res["code"]
                                )
                                || "network error"
                            )
                        )
                        || "network error";

                    if (typeof onFail == "function") {
                        if (!onFail(res)) { //若客户没有处理错误码，怎么默认显示错误消息或描述文字的弹窗
                            ToastPanel.show(errorMsg);
                        }
                    } else {
                        if (typeof onFail == "boolean" && onFail == true) {
                            Net.defaultOnFail && Net.defaultOnFail(res);
                        }
                        ToastPanel.show(errorMsg);
                    }
                }
            },
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        });
        console.log("requset", uri, param);
    }

    private static defaultOnFail: (res: any) => void = () => {
        SceneCtrl.instance.change(StartScene);
        PanelCtrl.instance.closeAll();
        Loading.instace.hide();
    }

    private static urlReplace(url: string) {
        Object.keys(Net.urlReplaceConfig).forEach(key => {
            url = url.replace(new RegExp(key, "g"), Net.urlReplaceConfig[key]);
        });
        return url;
    }

    private static urlReplaceConfig = {
        "{projectId}": function () {
            return "projectId"; //TODO
        }
    }

    public static readonly Url = {
        signData: "/projectx/{projectId}/join_1/data.do",
        signIn: "/projectx/{projectId}/join_1/join.do",
        queryProps: "/projectx/{projectId}/scoring_1/spData.do",
        start: "/projectx/{projectId}/scoring_1/start.do",
        finalSubmit: "/projectx/{projectId}/scoring_1/submit.do",
        revive: "/projectx/{projectId}/scoring_1/revive.do",
        constantSubmit: "/projectx/{projectId}/scoring_1/push.do",
        rankList: "/projectx/{projectId}/join_3/data.do",
        queryRankListData: "/{projectId}/getRanking.query",
        queryNickname: "/projectx/{projectId}/join_3/userInfoList.do",
        visit: "/projectx/{projectId}/scoring_1/visit.do",
        taskData: "/projectx/{projectId}/join_2/data.do",
        taskComplete: "/projectx/{projectId}/join_2/join.do"
    }
}