"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var DataConversion_1 = require("../mainScene/DataConversion");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var DogData_1 = require("../startScene/DogData");
var MsgPanel = (function (_super) {
    __extends(MsgPanel, _super);
    function MsgPanel(data) {
        var _this = _super.call(this, data) || this;
        _this.bgType = data.bgType;
        _this.type = data.type;
        _this.val1 = data.val1;
        _this.val2 = data.val2;
        _this.val3 = data.val3;
        _this.actData = data.actData;
        _this.callBack = data.callBack;
        return _this;
    }
    Object.defineProperty(MsgPanel.prototype, "skinKey", {
        get: function () { return 'MsgPanel'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MsgPanel.prototype, "groupName", {
        get: function () { return 'msg_panel'; },
        enumerable: true,
        configurable: true
    });
    MsgPanel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    };
    MsgPanel.prototype.start = function (data) {
        _super.prototype.start.call(this, data);
        this.percentHeight = 100;
    };
    MsgPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        if (this['msgBtn' + this.type]) {
            this['msgBtn' + this.type].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_msgBtn, this);
        }
        this['closeBtn' + this.bgType].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_closeBtn, this);
    };
    MsgPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        if (this['msgBtn' + this.type]) {
            this['msgBtn' + this.type].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_msgBtn, this);
        }
        this['closeBtn' + this.bgType].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_closeBtn, this);
    };
    MsgPanel.prototype.onLoad = function () {
        this.orgY = this['bgGroup' + this.bgType].y;
        this.initMsg();
    };
    MsgPanel.prototype.initMsg = function () {
        if (this.bgType == 3) {
            this['bgGroup' + 3].visible = true;
        }
        else {
            this['bgGroup' + 3].visible = false;
        }
        for (var i = 0; i < 3; i++) {
            if (i == this.bgType) {
                this['bgGroup' + i].visible = true;
            }
            else {
                this['bgGroup' + i].visible = false;
            }
        }
        for (var i = 0; i < 8; i++) {
            if (i == this.type) {
                this['msgGroup' + i].visible = true;
            }
            else {
                this['msgGroup' + i].visible = false;
            }
        }
        switch (this.type) {
            case 0:
                this["textLb0"].visible = true;
                this["textLb0"].text = ' 免费赠送你' + DataConversion_1.default.doConversion(this.val1) + '狗粮\n快用它召唤更多的汪星人吧！';
                break;
            case 3:
                this['textLb3'].text = '成功邀请好友加入了汪星人卫队\n您的狗粮迅速增加了'; //'成功邀请' + this.val1 + '名好友加入汪星人卫队\n您的狗粮迅速增加了';
                break;
            case 6:
                this['textLb6'].text = DataConversion_1.default.doConversion(this.val1) + '狗粮';
                break;
            case 7:
                this['dogImgGroup'].removeChildren();
                var img = new eui.Image();
                img.source = 'dog_lv_' + (this.val1) + '_png';
                img.anchorOffsetX = DogData_1.default.getSizeData[this.val1 - 1][0] * 0.5;
                img.anchorOffsetY = DogData_1.default.getSizeData[this.val1 - 1][1] * 0.5;
                img.x = this['dogImgGroup'].width * 0.5;
                img.y = this['dogImgGroup'].height * 0.5;
                this['dogImgGroup'].addChild(img);
                this['textLb7'].text = DogData_1.default.getNameData[this.val1 - 1];
                break;
            case 8:
                var munite = Math.floor(this.val1 / 60);
                this["textLb80"].text = Math.floor(munite / 60) + '小时' + (munite % 60) + '分钟啦';
                this["textLb81"].text = '' + DataConversion_1.default.doConversion(this.val2);
                this['textLb82'].text = '最多记录离线' + Math.floor(this.val3 / 3600) + '小时';
                break;
        }
    };
    MsgPanel.prototype.onTouchTap = function () {
        if (this.type == 0) {
            this.hidePanel();
        }
        else {
            this.hidePanel();
        }
    };
    MsgPanel.prototype.onTouchTap_msgBtn = function () {
        panelCtrl_1.default.instance.btnDelay(this['msgBtn' + this.type]);
        if (this.callBack) {
            this.callBack(false);
        }
        this.hidePanel();
    };
    MsgPanel.prototype.onTouchTap_closeBtn = function () {
        var _this = this;
        panelCtrl_1.default.instance.btnDelay(this['closeBtn' + this.bgType]);
        if (this.type == 7) {
            this.pMask.alpha = 0;
            var group = this['bgGroup' + this.bgType];
            group.anchorOffsetX = 750 * 0.5;
            group.anchorOffsetY = group.height * 0.5;
            group.x = 750 * 0.5;
            group.y = this.orgY + group.height * 0.5;
            var endX = this.actData.x; // - group.x;
            var endY = this.actData.y; // - group.y;
            egret.Tween.get(this['bgGroup' + this.bgType]).to({ x: endX, y: endY, scaleX: 0.1, scaleY: 0.1 }, 500).call(function () {
                if (_this.callBack) {
                    _this.callBack(true);
                }
                _this.hidePanel();
            });
            egret.Tween.get(this['bgGroup' + this.bgType]).wait(470).to({ alpha: 0 }, 30).call(function () {
                if (_this.callBack) {
                    _this.callBack(true);
                }
                _this.hidePanel();
            });
        }
        else {
            if (this.callBack) {
                this.callBack(true);
            }
            this.hidePanel();
        }
    };
    return MsgPanel;
}(Panel_1.default));
exports.default = MsgPanel;
__reflect(MsgPanel.prototype, "\"c:/Users/duiba/Documents/kuwo/egret/src/msgPanel/MsgPanel\".MsgPanel");
//# sourceMappingURL=MsgPanel.js.map