"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Loading_1 = require("../loading/Loading");
var TopLayerCtrl = (function () {
    function TopLayerCtrl() {
    }
    Object.defineProperty(TopLayerCtrl, "instance", {
        get: function () {
            return TopLayerCtrl._instance || (TopLayerCtrl._instance = new TopLayerCtrl());
        },
        enumerable: true,
        configurable: true
    });
    TopLayerCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    TopLayerCtrl.prototype.show = function (cls, data, hasMask, time) {
        if (hasMask === void 0) { hasMask = true; }
        if (time === void 0) { time = 2500; }
        Loading_1.default.instace.show();
        var panel = new cls(data, hasMask, time);
        this._current = panel;
        this.add(panel);
        this._parent.visible = true;
    };
    /**
     * 防止连点
     * @param targe 可交互对象
     * @param dtime 延时默认500ms
     */
    TopLayerCtrl.prototype.btnDelay = function (targe, dtime) {
        if (dtime === void 0) { dtime = 500; }
        targe.touchEnabled = false;
        setTimeout(function () {
            targe.touchEnabled = true;
        }, dtime);
    };
    TopLayerCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    TopLayerCtrl.prototype.remove = function (panel) {
        this._parent.removeChild(panel);
    };
    TopLayerCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        if (this._parent.numChildren == 0) {
            this._parent.visible = false;
        }
    };
    TopLayerCtrl.prototype.panelHide = function (panel) {
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        if (this._parent.numChildren == 0) {
            this._parent.visible = false;
        }
    };
    TopLayerCtrl.prototype.registerPanelClass = function (name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    };
    TopLayerCtrl.prototype.closeCurrent = function () {
        if (this._current)
            this.remove(this._current);
    };
    return TopLayerCtrl;
}());
exports.default = TopLayerCtrl;
__reflect(TopLayerCtrl.prototype, "\"c:/Users/duiba/Documents/zhonghe_answer/egret/src/ctrls/TopLayerCtrl\".TopLayerCtrl");
//# sourceMappingURL=TopLayerCtrl.js.map