"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Loading_1 = require("../loading/Loading");
var PanelCtrl = (function () {
    function PanelCtrl() {
    }
    Object.defineProperty(PanelCtrl, "instance", {
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: true,
        configurable: true
    });
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    PanelCtrl.prototype.show = function (cls, data, hasMask, time) {
        if (hasMask === void 0) { hasMask = true; }
        if (time === void 0) { time = 2500; }
        Loading_1.default.instace.show();
        var panel = new cls(data, hasMask, time);
        this._current = panel;
        this.add(panel);
        this._parent.visible = true;
    };
    /**
     * 防止连点
     * @param targe 可交互对象
     * @param dtime 延时默认500ms
     */
    PanelCtrl.prototype.btnDelay = function (targe, dtime) {
        if (dtime === void 0) { dtime = 500; }
        targe.touchEnabled = false;
        setTimeout(function () {
            targe.touchEnabled = true;
        }, dtime);
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
        panel.addEventListener('onCreditsOut', this.onCreditsOut, this);
    };
    PanelCtrl.prototype.remove = function (panel) {
        this._parent.removeChild(panel);
    };
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        panel.removeEventListener('onCreditsOut', this.onCreditsOut, this);
        this.remove(panel);
        if (this._parent.numChildren == 0) {
            this._parent.visible = false;
        }
    };
    PanelCtrl.prototype.onCreditsOut = function (e) {
        if (!window['CFG'] || !window['CFG'].appInfo)
            return;
        window.location.href = window['CFG'].appInfo.earnCreditsUrl;
    };
    PanelCtrl.prototype.closeCurrent = function () {
        if (this._current)
            this.remove(this._current);
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;
__reflect(PanelCtrl.prototype, "\"c:/Users/duiba/Documents/zhonghe_answer/egret/src/ctrls/PanelCtrl\".PanelCtrl");
//# sourceMappingURL=PanelCtrl.js.map