import ComponentBase from "../components/ComponentBase";

export default class FriendItem extends ComponentBase{
    private static _parent: eui.UILayer;
    private static _instance: FriendItem;
    public waitImg:eui.Image;
    static get instace(): FriendItem {
        return FriendItem._instance || (FriendItem._instance = new FriendItem());
    }
    constructor() {
        super();
        this.horizontalCenter = 0;
        this.verticalCenter = 0;
    }

    show() {
        FriendItem._parent.addChild(this);
        if (this.skin && !this.hasEventListener(egret.Event.ENTER_FRAME)){
            this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
        }

        FriendItem._parent.visible = true;
    }

    hide() {
        if(FriendItem._parent.getChildIndex(this) == -1) return;
        
        FriendItem._parent.removeChild(this);
        if (this.hasEventListener(egret.Event.ENTER_FRAME)){
            this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
        }

        if(FriendItem._parent.numChildren == 0){
            FriendItem._parent.visible = false;
        }   
    }

    static init(parent: eui.UILayer) {
        FriendItem._parent = parent;
    }

    onSkinComplete(): any {
        super.onSkinComplete();
        if (!this.hasEventListener(egret.Event.ENTER_FRAME))
            this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    onEnterFrame() {
        this.waitImg.rotation += 5;
    }

    public get skinKey() { return 'FriendItem' }
	public get groupName() { return 'frienditem'}
}