import { DataManager } from './../manager/DataManager';
import { IExposureData } from '../data/common/IExposureData';
import { NetManager } from '../manager/NetManager';
// import { IExposureData } from '..';

export class Buried {
    private static appId: number | string;
    private static oaId: number | string;

    /**
     * 初始化
     */
    public static init(appId: number, oaId: number | string): void {
        Buried.appId = appId;
        Buried.oaId = oaId;
    }

    /**
     * 创建dpm埋点数据
     */
    public static createExposure(appIdParam: string | number, embedDomain = '//embedlog.duiba.com.cn') {
        return {
            dpm: Buried.appId.toString() + `.110.${appIdParam}.1`,
            dcm: `202.${Buried.oaId}.0.0`,
            appId: Buried.appId.toString(),
            domain: embedDomain
        };
    }

    /**
     * dpm拼接
     * @param pageId 页面ID 
     * @param area 区域
     * @param dpm 埋点号
     * @returns {string}
     */
    public static connectDpm(pageId: number, area: number, dpm: number): string {
        return Buried.appId + '.' + pageId + '.' + area + '.' + dpm;
    }

    /**
     * dcm拼接
     * @param typeId 类型ID
     * @param contentInfo 内容信息
     * @param dcm 埋点号
     * @returns {string}
     */
    public static connectDcm(typeId: number, contentInfo: number, dcm: number): string {
        return typeId + '.' + Buried.oaId + '.' + contentInfo + '.' + dcm;
    }

    /**
     * 插件dcm拼接
     * @param plugId 插件ID
     * @param type 1 活动工具 2 主会场 4 楼层 5 游戏 7 子页面
     * @returns {string}
     */
    public static connectPlugDcm(plugId: number, type: number): string {
        return 212 + '.' + plugId + '.' + type + '.' + Buried.oaId;
    }

    /**
     * 活动dcm拼接
     * @param type 1 活动工具 2 主会场 4 楼层 5 游戏 7 子页面
     * @returns {string}
     */
    public static connectActivityDcm(type: number): string {
        return 202 + '.' + Buried.oaId + '.' + type + '.' + Buried.oaId;
    }


    private static doBuried(appIdParam: string | number, netManager: NetManager, callback: string) {
        let data = Buried.createExposure(appIdParam);
        netManager[callback](data);
        console.log("exposure", data);
    }

    public static doClickBuried(appIdParam: string | number) {
        Buried.doBuried(appIdParam, NetManager.ins, "clickLog");
    }
    public static doShowBuried(appIdParam: string | number) {
        Buried.doBuried(appIdParam, NetManager.ins, "showLog");
    }

}
