// import { IExposureData } from '../../data/common/IExposureData';
import { IExposureData } from '../../data/common/IExposureData';
import { LotteryData } from '../../data/common/lottery/LotteryData';
import { LotteryType } from '../../enum/LotteryType';
import { NetManager } from '../../manager/NetManager';
import { DataManager } from './../../manager/DataManager';
import { Model } from './../Model';

/**
 * 兑吧活动领域模型
 */
export class ActivityModel extends Model {
    /**
     * 插件抽奖
     * @param callback
     * @param plugId 
     */
    public plugDoJoin(callback: Function, plugId: number): void {
        NetManager.ins.doJoinPlugDraw((success: boolean) => {
            if(success) {
                this.getPlugOrderStatus(callback);
            } else {
                callback(success);
            }
        }, plugId);
    }

    /**
     * 插件抽奖订单结果
     * @param net 
     */
    public getPlugOrderStatus(callback: Function): void {
        NetManager.ins.getPlugOrderStatus(callback, DataManager.ins.doJoinPlugDrawData.orderId, () => {
            return DataManager.ins.getPlugOrderStatusData.result == 0;
        });
    }

    /**
     * 插件结果弹窗
     */
    public get plugIsWinning(): boolean {
        return DataManager.ins.getPlugOrderStatusData.lottery ? true : false;
    }
    
    /**
     * 曝光埋点
     */
    public showLog(): void {
        //曝光埋点
        if (this.lottery.imgExposure) {
            NetManager.ins.showLog(this.lottery.imgExposure);
        }
        //如果是福袋还需要推啊曝光
        if (this.lottery.type == "lucky") {
            NetManager.ins.spmshow(this.exposure);
        }
    }

    /**
     * 奖品图尺寸
     */
    public get optionImgSize(): string {
        let size: string;
        if (this.lottery.type == LotteryType.ALIPAY ||
            this.lottery.type == LotteryType.VIRTUAL ||
            this.lottery.type == LotteryType.OBJECT) {

            size = 's';
        } else {
            size = 'b';
        }
        return size;
    }

    /**
     * 奖品图片链接
     */
    public get optionImg(): string {
        return this.lottery.img;
    }

    /**
     * 奖品名字
     */
    public get optionName(): string {
        return this.lottery.name;
    }

    /**
     * 奖品数据
     */
    protected get lottery(): LotteryData {
        return;
    }

    /**
     * 福袋埋点数据
     */
    protected get exposure(): IExposureData {
        return;
    }

    /**
     * 立即使用
     */
    public onUse(): void {
        if (this.lottery.type == LotteryType.COUPON || this.lottery.type == LotteryType.LUCKY) {
            window["downloadAppConfig"] =
                {
                    openUrl: this.lottery.openUrl,
                    iosDownloadUrl: this.lottery.iosDownloadUrl,
                    androidDownloadUrl: this.lottery.androidDownloadUrl,
                    confirm: this.lottery.confirm ? this.lottery.confirm : false
                };
            window["downloadApp"]();
            if (this.lottery.type == "lucky") {
                NetManager.ins.spmclick(this.exposure);
            }
        }
        else {
            window.location.href = this.lottery.link;
        }
    }
}