import Scene from "../views/Scene";
import MButton from "../MUI/MButton";
import SceneCtrl from "../Ctrls/SceneCtrl";
import MainScene from "./MainScene";
import PanelCtrl from "../Ctrls/PanelCtrl";
import SignInPanel from "../Panel/SignInPanel";
import SelectPropsPanel from "../Panel/SelectPropsPanel";
import Net from "../Global/Net";
import { Decorator } from "../Decorator/Decorator";
import SoundMgr from "../Mgr/SoundMgr";
import GameMgr from "../Mgr/GameMgr";
import MovieClipMgr from "../Mgr/MovieClipMgr";
import RankListPanel from "../Panel/RankListPanel";
import ToastPanel from "../Components/ToastPanel";
import Loading from "../Loading/Loading";
import TaskPanel from "../Panel/TaskPanel";
import RulePanel from "../Panel/RulePanel";
import MyPropsPanel from "../Panel/MyPropsPanel";
import { MConfigs } from "../Global/MConfigs";
import SpUserPanel from "../Panel/SpUserPanel";
import { Buried } from "../../libs/tw/util/Buried";
import SharePanel from "../Panel/SharePanel";

interface StartButton extends MButton {
    labelStartShadow: eui.Label;
    labelStart: eui.Label;
    /* setText(text: string) {
        this.labelStart.text = text;
        this.labelStart.text = text;
    } */
}

@Decorator.ClassName("StartScene")
export default class StartScene extends Scene {
    public btnShare: eui.Button;
    public btnReward: eui.Button;
    public btnProps: eui.Button;
    public btnMusic: eui.ToggleButton;
    public btnStart: StartButton;
    public btnSignIn: MButton;
    public btnRule: MButton;
    public btnTask: MButton;
    public btnRankList: MButton;

    private leftTimes: number = null;
    private allPeriodEnd: boolean = false;

    async preLoadRes() {
        await super.preLoadRes();
        return new Promise(async resolve => {
            await RES.getResAsync("bgm_mp3");
            resolve();
        });
    }
    countVcon=0;
    onSkinComplete() {
        super.onSkinComplete();

        SoundMgr.instance.setMusic("bgm_mp3");

        if (!GameMgr.instance.hasSetMusic) {
            SoundMgr.instance.enabled = true;
        }

        this.btnReward.onTap(this, () => {
            location.href = MConfigs.rewardRecordUrl;
        });

        Buried.doShowBuried(2);
        this.btnStart.onOnceTap(this, (resume) => {
            if (!GameMgr.instance.hasSetMusic) {
                SoundMgr.instance.enabled = true;
                GameMgr.instance.hasSetMusic = true;
            }

            if (this.leftTimes == null) {
                resume();
            } else if (this.leftTimes <= 0) {
                ToastPanel.show("今日游戏次数已用完");
                resume();
            } else if (this.allPeriodEnd) {
                ToastPanel.show("该活动已结束！");
                resume();
            } else {
                Net.sendPost(Net.Url.start, undefined, (res) => {
                    SceneCtrl.instance.change(MainScene, { startId: res.data.startId });
                }, () => { resume() });
            }

            Buried.doClickBuried(2);
        });

        Buried.doShowBuried(3);
        this.btnSignIn.onTap(this, () => {
            if (this.allPeriodEnd) {
                ToastPanel.show("该活动已结束！");
                return;
            }
            PanelCtrl.instance.show(SignInPanel);

            Buried.doClickBuried(3);
        });

        this.btnMusic.selected = SoundMgr.instance.enabled;
        this.btnMusic.addEventListener(eui.UIEvent.CHANGE, (evt: eui.UIEvent) => {
            GameMgr.instance.hasSetMusic = true;
            SoundMgr.instance.enabled = (evt.target as eui.ToggleButton).selected;
        }, this);

        Buried.doShowBuried(5);
        this.btnRankList.onTap(this, () => {
            PanelCtrl.instance.show(RankListPanel, { defaultToggle: 1 });
            Buried.doClickBuried(5);
        });


        // this.btnTask.visible = window['channel']=="app";
        this.btnTask.visible = false;
        Buried.doShowBuried(4);
        this.btnTask.onTap(this, () => {
            PanelCtrl.instance.show<TaskPanel>(TaskPanel).onCompleteTask = () => {
                this.refresh();
            };
            Buried.doClickBuried(4);
        });

       

        this.btnRule.onTap(this, () => {
            PanelCtrl.instance.show(RulePanel, { msg: MConfigs.rule });
            this.countVcon++
            if(this.countVcon==10){
                var oHead = document.querySelector('body');
                var oScript = document.createElement('script');
                oScript.type = 'text/javascript';
                oScript.src = '//yun.duiba.com.cn/webapp/js/vconsole.min.js';
                oHead.appendChild(oScript);
                oScript.onload = function() {
                    var vConsole = new window["VConsole"]();
                }
            }
        });

        this.btnProps.onTap(this, () => {
            PanelCtrl.instance.show(MyPropsPanel);
        });
        //yun.duiba.com.cn/polaris/%E5%B9%B3%E5%AE%89%E5%8D%A1%E4%B8%AD%E5%BF%83%E6%89%93%E6%98%9F%E7%90%83%E6%B5%8B%E8%AF%95.43bd504768c343c07c409e368666a02c56ea54cd.json
        Buried.doShowBuried(1);
        this.btnShare.onTap(this, () => {
            //端内分享
            // if(window["channel"]=="app"){
            //     window["share"]();
            // }else{
                PanelCtrl.instance.show(SharePanel);
            // }
            Buried.doClickBuried(1);
        });
        this.refresh();
    }

    private refresh() {
        Net.sendGet(Net.Url.visit, undefined, (res) => {
            GameMgr.instance.minEnableCaptchaScore = res.data.minEnableCaptchaScore;
            this.leftTimes = res.data.leftTimes;
            const text = "开始游戏×" + this.leftTimes;
            this.btnStart.labelStart.text = text;
            this.btnStart.labelStartShadow.text = text;
            this.allPeriodEnd = res.data.allPeriodEnd;

            if (typeof res.data.rewardSpId == "string") {
                PanelCtrl.instance.show(SpUserPanel);
            }

            if (res.data.prevPrizePopUp) {
                PanelCtrl.instance.show(RankListPanel, { defaultToggle: 2 });
            }
        }, () => { Loading.instace.show() });
    }
}