import Panel from "../views/Panel";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import SceneCtrl from "../Ctrls/SceneCtrl";
import StartScene from "../Scene/StartScene";
import MLabel from "../MUI/MLabel";

@Decorator.ClassName("WinningPanel")
export default class WinningPanel extends Panel {
    public labelScore: MLabel;
    public labelHighestScore: MLabel;
    public imgReward: eui.Image;
    public labelCoinNum: eui.Label;
    public btnClose: MButton;
    data: {
        score: number,
        highestScore: number,
        rewardImgUrl: string,
        rewardName: number
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => {
            this.hidePanel();
            SceneCtrl.instance.change(StartScene);
        });
        this.labelScore.text = this.data.score.toString() + "/e分";
        let text = typeof this.data.highestScore == "number" ? this.data.highestScore.toString() + "/e分" : "-";
        this.labelHighestScore.text = text;
        this.imgReward.source = this.data.rewardImgUrl+"?state="+Date.now();;
        this.labelCoinNum.text = this.data.rewardName + "已入账";
    }
}