import Panel from "../views/Panel";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import { Buried } from "../../libs/tw/util/Buried";

@Decorator.ClassName("SpUserPanel")
export default class SpUserPanel extends Panel {
    public btn: MButton;
    public btnClose: MButton;
    @Decorator.LightRotate(7000)
    public light: eui.Image;

    onSkinComplete() {
        super.onSkinComplete();

        this.btnClose.onTap(this, () => {
            this.onClose();
        });
        Buried.doShowBuried(13);
        this.btn.onTap(this, () => {
            Buried.doClickBuried(13);
            this.onClose();
        });
    }

    onClose() {
        this.hidePanel()
    }

}