import Drop from "../Game/Drop";
import { arrayRemove } from "../Global/GUtils";

export default class DropBlinkMgr {
    private static _instance: DropBlinkMgr = null;
    public static get instance(): DropBlinkMgr {
        if (!this._instance) {
            this._instance = new DropBlinkMgr();
        }

        return this._instance;
    }

    private list: {
        drop: Drop,
        count: number
    }[] = [];
    public add(drop: Drop) {
        this.list.push({
            drop: drop,
            count: 0
        });
    }
    public remove(drop: Drop) {
        this.list = this.list.filter(e => e.drop !== drop);
    }

    public static init() {
        egret.MainContext.instance.stage.addEventListener(egret.Event.ENTER_FRAME, DropBlinkMgr.instance.onUpdate, DropBlinkMgr.instance);
    }

    private frameTimer: number = 0;

    public onUpdate() {
        if (this.frameTimer % BlinkDuration == 0) {
            let temp: {
                drop: Drop,
                count: number
            } = null;
            for (let i in this.list) {
                temp = this.list[i];
                temp.drop.visible = !temp.drop.visible;
                temp.count++;
            }
            this.list = this.list.filter(e => {
                if (e.count < 60 / BlinkDuration * 2) {
                    return true;
                } else {
                    e.drop.destroy();
                    return false;
                }

            });
        }
        this.frameTimer++;
    }
}

const BlinkDuration = 3;