import GameMgr from "./GameMgr";

export default class DebugMgr extends egret.DisplayObjectContainer {
    public enabled: boolean = false;
    public enabledGraphic: boolean = false;
    private shapeMap = {};
    private graphicDebugLayer: egret.DisplayObjectContainer = null;
    private uiLayer: eui.UILayer = null;
    private log: eui.Label = null;

    public onClick = () => { }

    constructor() {
        super();
        if (!this.enabled) return;
        //创建图形调试层
        this.graphicDebugLayer = new egret.DisplayObjectContainer();
        this.graphicDebugLayer.touchEnabled = false;
        this.addChild(this.graphicDebugLayer);
        //创建UI层
        this.uiLayer = new eui.UILayer();
        this.uiLayer.touchThrough = true;
        this.addChild(this.uiLayer);
        //创建日志标签
        this.log = new eui.Label("Log");
        this.log.horizontalCenter = 0;
        this.log.top = 50;
        this.log.textColor = 0xffffff;
        this.log.stroke = 0.5;
        this.log.size = 32;
        this.uiLayer.addChild(this.log);
        //创建调试按钮
        let button = new eui.Label("调试");
        button.textColor = 0x000000;
        button.borderColor = 0x000000;
        button.border = true;
        button.top = 30;
        button.right = 50;
        this.uiLayer.addChild(button);
        button.onTap(this, () => {
            this.onClick();
        });
    }

    public setLog(msg: string) {
        if (!this.enabled) return;
        this.log.text = msg;
    }

    public drawRect(rect: egret.Rectangle, style: GraphicDebug.Style = { color: 0xff0000, lineSize: 1 }) {
        if (!this.enabled || !this.enabledGraphic) return;
        let shape = new egret.Shape();
        shape.graphics.lineStyle(style.lineSize, style.color);
        shape.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
        this.graphicDebugLayer.addChild(shape);
    }

    public drawCircle(x: number, y: number, radius: number, style: GraphicDebug.Style = { color: 0xff0000, lineSize: 1 }) {
        if (!this.enabled || !this.enabledGraphic) return;

        let shape = new egret.Shape();
        shape.graphics.lineStyle(style.lineSize, style.color);
        shape.graphics.drawCircle(x, y, radius);
        this.graphicDebugLayer.addChild(shape);
    }

    public drawLine(line: GraphicDebug.Line, style: GraphicDebug.Style = { color: 0xff0000, lineSize: 1 }) {
        if (!this.enabled || !this.enabledGraphic) return;
        let shape = new egret.Shape();
        shape.graphics.lineStyle(style.lineSize, style.color);
        shape.graphics.moveTo(line.startX, line.startY);
        shape.graphics.lineTo(line.endX, line.endY);
        this.graphicDebugLayer.addChild(shape);
    }

    public updateLine(key: string, line: GraphicDebug.Line, style: GraphicDebug.Style = { color: 0xff0000, lineSize: 1 }) {
        if (!this.enabled || !this.enabledGraphic) return;
        let shape: egret.Shape = this.shapeMap[key];
        if (!shape) {
            shape = new egret.Shape();
            this.graphicDebugLayer.addChild(shape);
            this.shapeMap[key] = shape;
        }

        shape.graphics.clear();
        shape.graphics.lineStyle(style.lineSize, style.color);
        shape.graphics.moveTo(line.startX, line.startY);
        shape.graphics.lineTo(line.endX, line.endY);
    }

    public updateRect(key: string, rect: egret.Rectangle, style: GraphicDebug.Style = { color: 0xff0000, lineSize: 1 }) {
        if (!this.enabled || !this.enabledGraphic) return;
        let shape: egret.Shape = this.shapeMap[key];
        if (!shape) {
            shape = new egret.Shape();
            this.graphicDebugLayer.addChild(shape);
            this.shapeMap[key] = shape;
        }

        shape.graphics.clear();
        shape.graphics.lineStyle(style.lineSize, style.color);
        shape.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    public updateCircle(key: string, x: number, y: number, radius: number, style: GraphicDebug.Style = { color: 0xff0000, lineSize: 1 }) {
        if (!this.enabled || !this.enabledGraphic) return;
        let shape: egret.Shape = this.shapeMap[key];
        if (!shape) {
            shape = new egret.Shape();
            this.graphicDebugLayer.addChild(shape);
            this.shapeMap[key] = shape;
        }

        shape.graphics.clear();
        shape.graphics.lineStyle(style.lineSize, style.color);
        shape.graphics.drawCircle(x, y, radius);
    }

    public clearShape(key: string) {
        if (!this.enabled || !this.enabledGraphic) return;
        let shape: egret.Shape = this.shapeMap[key];
        if (!shape) {
            console.warn("collider is nonexistent");
            return;
        }

        delete this.shapeMap[key];
        shape.destroy();
    }

    private static _instance: DebugMgr = null;
    public static get instance(): DebugMgr {
        if (!this._instance) {
            if (egret.MainContext.instance.stage) {
                this._instance = new DebugMgr();
                egret.MainContext.instance.stage.addChild(this._instance);
            } else {
                console.error("stage is null,DebugMgr can not instantiate");
            }
        }

        return this._instance;
    }
}

export namespace GraphicDebug {
    export interface Style {
        color: number;
        lineSize: number;
    }
    export interface Line {
        startX: number;
        startY: number;
        endX: number;
        endY: number;
    }
}


