import { Decorator } from "../Decorator/Decorator";

const ProgressBarType = {
    Horizontal: "horizontal",
    Vertical: "vertical"
}

@Decorator.OnUpdate
class MProgressBar extends eui.Component implements eui.UIComponent, Decorator.IDefaultCallback {
    public style: string = "horizontal";
    public reversed: boolean = false;
    public fill: eui.Image;
    public tween: number = 100;
    private inited = false;

    private updateTween: () => void;

    onUpdate(dt: number) {
        this.updateTween && this.updateTween();
    }

    private get fillMask() {
        if (this.fill) {
            return this.fill.mask as eui.Image;
        } else {
            return null;
        }
    }

    private doTween(prop: string, value: number, duration: number) {
        if (duration == 0) {
            console.error("invalid duration");
            return;
        }

        let count = duration / (1000 / 60);
        let once = (value - this.fillMask[prop]) / count;
        this.updateTween = () => {
            if (count > 0) {
                this.fillMask[prop] += once;
                if (this.reversed) {
                    if (prop == "height") {
                        this.fillMask.anchorOffsetY = this.fillMask.height;
                    } else {
                        this.fillMask.anchorOffsetX = this.fillMask.width;
                    }
                }
                count--;
            }
        }
    }

    public get value() {
        return this._value;
    }
    public set value(v: number) {
        this._value = Math.clamp(v, 0, 1);

        if (!this.inited) {
            this.init();
        }

        //皮肤中要显示指定fill的width，不然开始时会获取不到width
        if (this.style == ProgressBarType.Vertical) {

            if (this.tween > 0) {
                this.doTween("height", this.fill.height * this._value, this.tween);
            } else {
                this.fillMask.height = this.fill.height * this._value;
                if (this.reversed) {
                    this.fillMask.anchorOffsetY = this.fillMask.height;
                }
            }
        } else {
            if (this.tween > 0) {
                this.doTween("width", this.fill.width * this._value, this.tween);
            } else {
                this.fillMask.width = this.fill.width * this._value;
                if (this.reversed) {
                    this.fillMask.anchorOffsetX = this.fillMask.width;
                }
            }
        }
    }
    private _value: number = 0.5;

    private init() {
        let fillMask = new eui.Image(this.fill.source);
        fillMask.scale9Grid = this.fill.scale9Grid;
        this.fill.parent.addChild(fillMask);

        if (!isNaN(this.fill.left)) {
            fillMask.x = this.fill.left;
        } else if (!isNaN(this.fill.horizontalCenter)) {
            fillMask.x = this.fill.parent.width / 2 + this.fill.horizontalCenter - this.fill.width / 2;
        } else {
            fillMask.x = this.fill.x;
        }
        if (!isNaN(this.fill.top)) {
            fillMask.y = this.fill.top;
        } else if (!isNaN(this.fill.verticalCenter)) {
            fillMask.y = this.fill.parent.height / 2 + this.fill.verticalCenter - this.fill.height / 2;
        } else {
            fillMask.y = this.fill.y;
        }
        this.fill.mask = fillMask;
        this.inited = true;

        if (this.reversed) {
            if (this.style == ProgressBarType.Vertical) {
                fillMask.y += this.fill.height;
            } else {
                fillMask.x += this.fill.width;
            }
        }
    }
}

export default MProgressBar;