"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Loading_1 = require("../../loading/Loading");
var NetManager_1 = require("../../../libs/tw/manager/NetManager");
var DataManager_1 = require("../../../libs/tw/manager/DataManager");
var getStartOrderStatus = function (callback, customizedType) {
    NetManager_1.NetManager.ins.getStartStatus(callback, DataManager_1.DataManager.ins.doStartData.ticketId, function () { return DataManager_1.DataManager.ins.getStartStatusData.code != 1; }, 5, customizedType);
};
/**
* 开始游戏
* @param {string} isAgain 是否是再来一次
* @param {number} credits 主动要求花费多少积分玩游戏
* @param {number} customizedType xx类型
*/
exports.default = function (isAgain, credits, customizedType) {
    if (isAgain === void 0) { isAgain = false; }
    return new Promise(function (resolve) {
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        var callback = function (data) {
            Loading_1.default.instace.hide();
            resolve(data);
        };
        Loading_1.default.instace.show();
        NetManager_1.NetManager.ins.doStart(function (success) {
            if (success) {
                getStartOrderStatus(callback, customizedType);
            }
            else {
                callback(success);
            }
        }, isAgain, credits, customizedType);
    });
};
//# sourceMappingURL=doStart.js.map