import Scene from "../views/Scene";
import MyImage from "./MyImage";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { GTime } from "../../libs/tc/util/GTime";
import { TimeFormat } from "../../libs/tc/enum/TimeFormat";
import Panel from "../views/Panel";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import { Buried } from "../../libs/tw/util/Buried";
import ComponentBase from "../components/ComponentBase";
import GuidePanel from "../guidePanel/GuidePanel";
import { GCache } from "../../libs/tc/util/GCache";
import Loading from "../loading/Loading";
import { GetPrizeInfoData } from "../../libs/tw/data/plug/getPrizeInfo/GetPrizeInfoData";
import { ABNetManager } from "../../libs/tc/manager/ABNetManager";
import FriendItem from "./FriendItem";
import { NetName } from "../../libs/tw/enum/NetName";
import DogItem from "./DogItem";

export default class MainScene extends Scene {

	public topGroup: eui.Group;
	public lvText: eui.Label;
	public foodCountText: eui.Label;
	public teamCountText: eui.Label;
	public yieldRateText: eui.Label;
	public team_0: eui.Group;
	public team_1: eui.Group;
	public team_2: eui.Group;
	public team_3: eui.Group;
	public team_4: eui.Group;
	public team_5: eui.Group;
	public bottomGroup: eui.Group;
	public getDogText: eui.Label;
	public doglist_0: eui.Group;
	public doglist_1: eui.Group;
	public doglist_2: eui.Group;
	public doglist_3: eui.Group;
	public doglist_4: eui.Group;
	public doglist_5: eui.Group;
	public doglist_6: eui.Group;
	public doglist_7: eui.Group;
	public doglist_8: eui.Group;
	public doglist_9: eui.Group;
	public doglist_10: eui.Group;
	public doglist_11: eui.Group;



	private dogLvLists = [
		"小奶狗",
		"小白狗",
		"小黑狗",
		"小狼狗",
		"金毛",
		"柯基",
		"柴犬",
		"博美",
		"泰迪",
		"巴哥犬",
		"比熊",
		"雪纳瑞",
		"秋田犬",
		"萨摩耶",
		"贵宾犬",
		"边境牧羊犬",
		"拉布拉多",
		"哈士奇",
		"吉娃娃",
		"法国斗牛犬",
		"牛头梗",
		"蝴蝶犬",
		"杜宾",
		"松狮",
		"茶杯犬",
		"苏格兰牧羊犬",
		"英国玩具犬",
		"迦南犬",
		"阿拉斯加雪橇犬",
		"阿富汗猎犬",
	]


	public get skinKey() { return 'MainScene' }
	public get groupName() { return 'main_scene' }

	private teams = [];
	private doglists = [];
	constructor(data?) {
		super(data);
		if (data) {

		}
		this.percentHeight = 100;
	}

	initEvents() {
		GDispatcher.addEvent(ABNetManager.ERROR, this.onError, this);

		for (let i = 0; i < 6; i++) {
			this.teams[i] = new FriendItem()
			this.teams[i].x = 0;
			this.teams[i].y = 0;
			this["team_" + i].addChild(this.teams[i])
			/* this.teams[i].setLoadVal(50)
			this.teams[i].setState(true) */
		}

		for (let i = 0; i < 12; i++) {
			this.doglists[i] = new DogItem()
			this.doglists[i].x = -8;
			this.doglists[i].y = -60;
			this["doglist_" + i].addChild(this.doglists[i])
		}
	}

	private onError(net: any, code: any): void {
		console.log(code);
		var msg: string;
		var msgArr: any = window['errorMessage'];
		if (!isNaN(code)) {
			msg = msgArr[code] ? msgArr[code] : '额哦，一个未知的错误';
		} else {
			msg = code;
		}

		PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, [msg], false);
	}
	removeEvents() {
		this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
		GDispatcher.removeEvent(ABNetManager.ERROR, this.onError, this);
	}

	protected onSkinComplete(): void {
		super.onSkinComplete();
		NetManager.ins.getHome((succuss) => {
			if (!succuss) {
				return;
			}
			this.updateIndex()
		}, "")
	}

	homeData
	teamData
	dogData

	updateIndex() {
		console.log(DataManager.ins.getData(NetName.GET_HOME))
		this.homeData = DataManager.ins.getData(NetName.GET_HOME).data;
		if (this.homeData) {
			this.teamData = this.homeData.team
			this.dogData = this.homeData.dogs
			this.updateTeam()
			this.updateDogList()
			this.updateAllText()
		}
	}

	updateAllText() {
		if(this.homeData.maxLevel){
			this.lvText.text = `LV.${this.homeData.maxLevel}${this.dogLvLists[this.homeData.maxLevel-1]}`
		}

		if(this.homeData.yieldRate){
			this.yieldRateText.text = `+${this.homeData.yieldRate}g/秒`
		}

		if(this.homeData.foodStocks){
			this.foodCountText.text = `${this.homeData.foodStocks}g`
		}
	}

	dataConversion(val){
		var l=val.toString().length;
		if(l>=4&&l<5){
			return (val/1000).toFixed(2).toString()+"k"
		}else if(l>=5&&l<7){
			return (val/10000).toFixed(2).toString()+"w"
		}else if(l>=7&&l<9){
			return (val/1000000).toFixed(2).toString()+"m"
		}else if(l>=9&&l<10){
			return (val/1000000).toFixed(2).toString()+"E"
		}else if(l>=10&&l<12){
			return (val/1000000).toFixed(2).toString()+"b"
		}else if(l>=12&&l<13){
			return (val/1000000).toFixed(2).toString()+"t"
		}else if(l>=13&&l<14){
			return (val/1000000).toFixed(2).toString()+"g"
		}else if(l>=14&&l<15){
			return (val/1000000).toFixed(2).toString()+"z"
		}
	}


	updateTeam() {
		for (let i = 0; i < 6; i++) {
			if (this.teamData[i]) {
				this.teams[i].setLoadVal((24 * 60 - this.teamData[i].remainingTime) / (24 * 60) * 100)
				this.teams[i].setState(true)
				this.teams[i].setImgUrl(this.teamData[i].avatar)
			} else {
				this.teams[i].setState(false)
			}

		}
	}


	updateDogList() {
		for (let i = 0; i < 12; i++) {
			if (this.dogData[i]) {
				this.doglists[i].setLv(this.dogData[i].level)
			}
		}
	}



	start(data?) {

	}

	protected onLoad(): void {
		this.initUI();

		this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
	}

	private initUI(): void {
		//初始化数据
		this.initData();

	}
	private initData(): void {
	}


	private onEnterFrame(): void {

	}

}